/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.jpinyin;

import com.webapp.utils.jpinyin.PinyinResource;
import java.util.Map;
import java.util.Properties;

public final class ChineseHelper {
    private static final Properties CHINESETABLE = PinyinResource.getChineseTable();

    public static char convertToSimplifiedChinese(char c) {
        if (ChineseHelper.isTraditionalChinese(c)) {
            return CHINESETABLE.getProperty(String.valueOf(c)).charAt(0);
        }
        return c;
    }

    public static char convertToTraditionalChinese(char c) {
        String hanzi = String.valueOf(c);
        if (CHINESETABLE.containsValue(hanzi)) {
            for (Map.Entry<Object, Object> e : CHINESETABLE.entrySet()) {
                if (!e.getValue().toString().equals(hanzi)) continue;
                return e.getKey().toString().charAt(0);
            }
        }
        return c;
    }

    public static String convertToSimplifiedChinese(String str) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            sb.append(ChineseHelper.convertToSimplifiedChinese(c));
        }
        return sb.toString();
    }

    public static String convertToTraditionalChinese(String str) {
        StringBuilder sb = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            sb.append(ChineseHelper.convertToTraditionalChinese(c));
        }
        return sb.toString();
    }

    public static boolean isTraditionalChinese(char c) {
        return CHINESETABLE.containsKey(String.valueOf(c));
    }

    public static boolean isChinese(char c) {
        String regex = "[\\u4e00-\\u9fa5]";
        return String.valueOf(c).matches(regex);
    }
}

