/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.thread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolUtils.class);

    public <T> List<FutureTask<T>> execute(ExecutorService executor, Callable<T> callable, int loopSize) {
        ArrayList<FutureTask<T>> futureTasks = new ArrayList<FutureTask<T>>();
        for (int i = 0; i < loopSize; ++i) {
            FutureTask<T> task = new FutureTask<T>(callable);
            executor.submit(task);
            futureTasks.add(task);
        }
        return futureTasks;
    }

    public <T> List<T> submitResult(ExecutorService executor, Callable<T> callable, int loopSize) {
        ArrayList<T> result = new ArrayList<T>();
        List<Future<T>> futures = this.submit4Future(executor, callable, loopSize);
        try {
            for (Future<T> future : futures) {
                result.add(future.get());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("\u83b7\u53d6\u7ed3\u679c\u51fa\u9519\uff01", (Throwable)e);
        }
        return result;
    }

    public <T> List<Future<T>> submit4Future(ExecutorService executor, Callable<T> callable, int loopSize) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
        for (int i = 0; i < loopSize; ++i) {
            Future<T> future = executor.submit(callable);
            futures.add(future);
        }
        return futures;
    }

    public <T> CompletionService<T> submit4Complete(ExecutorService executor, Callable<T> callable, int loopSize) {
        ExecutorCompletionService<T> cs = new ExecutorCompletionService<T>(executor);
        for (int i = 0; i < loopSize; ++i) {
            cs.submit(callable);
        }
        return cs;
    }

    public <T> CompletionService<T> submit4Complete(ExecutorService executor, Runnable runnable, int loopSize, T result) {
        ExecutorCompletionService<T> cs = new ExecutorCompletionService<T>(executor);
        for (int i = 0; i < loopSize; ++i) {
            cs.submit(runnable, result);
        }
        return cs;
    }

    public static ExecutorService newThreadPool(int minPoolSize, int maxPoolSize, int keepAliveTime, BlockingQueue<Runnable> workQueue) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(minPoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, workQueue);
        executor.setCorePoolSize(minPoolSize);
        executor.setMaximumPoolSize(maxPoolSize);
        executor.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
        executor.allowCoreThreadTimeOut(false);
        executor.setThreadFactory(Executors.defaultThreadFactory());
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy());
        return executor;
    }
}

