/*
 * Decompiled with CFR 0.152.
 */
package com.webapp.utils.servlet;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class CookieUtils {
    public static String getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = CookieUtils.readCookieMap(request);
        if (cookieMap.containsKey(name)) {
            Cookie cookie = cookieMap.get(name);
            return cookie.getValue();
        }
        return null;
    }

    public static boolean hasCookie(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = CookieUtils.readCookieMap(request);
        return cookieMap.containsKey(name);
    }

    protected static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (int i = 0; i < cookies.length; ++i) {
                cookieMap.put(cookies[i].getName(), cookies[i]);
            }
        }
        return cookieMap;
    }
}

