/*
 * Decompiled with CFR 0.152.
 */
package com.github.sviperll.writejava4me;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.github.sviperll.writejava4me.GeneratesClass;
import com.github.sviperll.writejava4me.GeneratesCode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class GeneratesCodeProcessor
extends AbstractProcessor {
    private Map<TypeElement, GeneratesClass[]> annotations = new HashMap<TypeElement, GeneratesClass[]>();
    private List<String> errors = new ArrayList<String>();

    @Override
    public boolean process(Set<? extends TypeElement> processEnnotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            for (String string : this.errors) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string);
            }
        } else {
            GeneratesClass[] generatesDirectives;
            TypeElement annotationClassElement;
            for (Element element : roundEnv.getElementsAnnotatedWith(GeneratesCode.class)) {
                annotationClassElement = (TypeElement)element;
                generatesDirectives = element.getAnnotation(GeneratesCode.class).value();
                this.annotations.put(annotationClassElement, generatesDirectives);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(GeneratesClass.class)) {
                annotationClassElement = (TypeElement)element;
                generatesDirectives = new GeneratesClass[]{element.getAnnotation(GeneratesClass.class)};
                this.annotations.put(annotationClassElement, generatesDirectives);
            }
            Generator generator = new Generator(this.processingEnv, (MustacheFactory)new DefaultMustacheFactory());
            for (Map.Entry<TypeElement, GeneratesClass[]> entry : this.annotations.entrySet()) {
                TypeElement annotationClassElement2 = entry.getKey();
                for (Element element : roundEnv.getElementsAnnotatedWith(annotationClassElement2)) {
                    for (GeneratesClass directive : entry.getValue()) {
                        List<? extends AnnotationMirror> appliedAnnotations = element.getAnnotationMirrors();
                        for (AnnotationMirror annotationMirror : appliedAnnotations) {
                            if (!this.processingEnv.getTypeUtils().isAssignable(annotationClassElement2.asType(), annotationMirror.getAnnotationType())) continue;
                            generator.generateClass((TypeElement)element, annotationMirror, directive);
                        }
                    }
                }
            }
        }
        return true;
    }

    private static class Generator {
        private final ProcessingEnvironment processingEnv;
        private final MustacheFactory mustacheFactory;

        public Generator(ProcessingEnvironment processingEnv, MustacheFactory mustacheFactory) {
            this.processingEnv = processingEnv;
            this.mustacheFactory = mustacheFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateClass(TypeElement element, AnnotationMirror annotation, GeneratesClass directive) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating " + directive.classNameTemplateString() + " class form " + directive.classTemplateResourcePath() + " template with context " + annotation + " and declaring class " + element.getQualifiedName().toString());
            HashMap<String, String> thisScope = new HashMap<String, String>();
            thisScope.put("annotated", element.getSimpleName().toString());
            PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(element);
            String packageName = packageElement.getQualifiedName().toString();
            thisScope.put("package", packageName);
            HashMap<String, Object> annotationScope = this.toScope(annotation);
            annotationScope.put("this", thisScope);
            Object[] scope = new Object[]{annotationScope, thisScope};
            System.out.println("annotationScope = " + annotationScope);
            System.out.println("thisScope = " + thisScope);
            Mustache classNameMustache = this.mustacheFactory.compile((Reader)new StringReader(directive.classNameTemplateString()), "classNameTemplateString");
            StringWriter stringWriter = new StringWriter();
            classNameMustache.execute((Writer)stringWriter, scope);
            stringWriter.flush();
            String className = stringWriter.toString();
            thisScope.put("class", className);
            Mustache mustache = this.mustacheFactory.compile(directive.classTemplateResourcePath());
            try {
                JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(packageName + "." + className, element);
                OutputStream stream = sourceFile.openOutputStream();
                try {
                    OutputStreamWriter writer = new OutputStreamWriter(stream);
                    try {
                        mustache.execute((Writer)writer, scope);
                    }
                    finally {
                        ((Writer)writer).close();
                    }
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        private HashMap<String, Object> toScope(AnnotationMirror annotation) {
            HashMap<String, Object> scope = new HashMap<String, Object>();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
                scope.put(entry.getKey().getSimpleName().toString(), this.toScopeValue(entry.getValue()));
            }
            return scope;
        }

        private Object toScopeValue(Object value) {
            if (value instanceof TypeMirror) {
                return this.toTypeName((TypeMirror)value);
            }
            if (value instanceof VariableElement) {
                return this.toEnumConstantName((VariableElement)value);
            }
            if (value instanceof AnnotationMirror) {
                return this.toScope((AnnotationMirror)value);
            }
            if (value instanceof List) {
                ArrayList<Object> result = new ArrayList<Object>();
                List annotationValues = (List)value;
                for (AnnotationValue annotationValue : annotationValues) {
                    result.add(this.toScopeValue(annotationValue));
                }
                return result;
            }
            if (value instanceof AnnotationValue) {
                AnnotationValue annotationValue = (AnnotationValue)value;
                return this.toScopeValue(annotationValue.getValue());
            }
            System.out.println(value.getClass().getName() + ": " + value);
            return value;
        }

        private String toTypeName(TypeMirror type) {
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                return this.toTypeName(arrayType.getComponentType()) + "[]";
            }
            if (type instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)type;
                TypeElement typeDeclaration = (TypeElement)declaredType.asElement();
                return typeDeclaration.getQualifiedName().toString();
            }
            throw new UnsupportedOperationException("Not supported");
        }

        private String toEnumConstantName(VariableElement enumConstant) {
            return enumConstant.getSimpleName().toString();
        }
    }
}

