/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client;

import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.exception.SwitcherContextException;
import com.github.switcherapi.client.model.ContextKey;
import org.apache.commons.lang3.StringUtils;

class SwitcherContextValidator {
    public static final String ERR_URL = "URL not defined [add: switcher.url]";
    public static final String ERR_API = "API Key not defined [add: switcher.apikey]";
    public static final String ERR_DOMAIN = "Domain not defined [add: switcher.domain]";
    public static final String ERR_COMPONENT = "Component not defined [add: switcher.component]";
    public static final String ERR_CONTEXT = "Context class location not defined [add: switcher.context]";
    public static final String ERR_LOCAL = "Snapshot location not defined [add: switcher.snapshot.location] or enable auto-load [add: switcher.snapshot.auto]";

    private SwitcherContextValidator() {
    }

    public static void validate(SwitcherProperties prop) {
        if (StringUtils.isBlank((CharSequence)prop.getValue(ContextKey.CONTEXT_LOCATION))) {
            throw new SwitcherContextException(ERR_CONTEXT);
        }
        if (!prop.getBoolean(ContextKey.LOCAL_MODE)) {
            SwitcherContextValidator.validateRemote(prop);
        } else {
            SwitcherContextValidator.validateLocal(prop);
        }
    }

    public static void validateRemote(SwitcherProperties prop) {
        if (StringUtils.isBlank((CharSequence)prop.getValue(ContextKey.URL))) {
            throw new SwitcherContextException(ERR_URL);
        }
        if (StringUtils.isBlank((CharSequence)prop.getValue(ContextKey.APIKEY))) {
            throw new SwitcherContextException(ERR_API);
        }
        if (StringUtils.isBlank((CharSequence)prop.getValue(ContextKey.DOMAIN))) {
            throw new SwitcherContextException(ERR_DOMAIN);
        }
        if (StringUtils.isBlank((CharSequence)prop.getValue(ContextKey.COMPONENT))) {
            throw new SwitcherContextException(ERR_COMPONENT);
        }
    }

    public static void validateLocal(SwitcherProperties prop) {
        if (StringUtils.isBlank((CharSequence)prop.getValue(ContextKey.SNAPSHOT_LOCATION)) && !prop.getBoolean(ContextKey.SNAPSHOT_AUTO_LOAD)) {
            throw new SwitcherContextException(ERR_LOCAL);
        }
    }
}

