/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client;

import com.github.switcherapi.client.SwitcherExecutor;
import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.exception.SwitcherRemoteException;
import com.github.switcherapi.client.exception.SwitcherSnapshotWriteException;
import com.github.switcherapi.client.model.ContextKey;
import com.github.switcherapi.client.model.criteria.Domain;
import com.github.switcherapi.client.model.criteria.Snapshot;
import com.github.switcherapi.client.service.remote.ClientRemote;
import com.github.switcherapi.client.utils.SnapshotLoader;
import com.github.switcherapi.client.utils.SwitcherUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SwitcherExecutorImpl
implements SwitcherExecutor {
    private static final Logger logger = LoggerFactory.getLogger(SwitcherExecutorImpl.class);
    protected final SwitcherProperties switcherProperties;
    protected Domain domain;

    protected SwitcherExecutorImpl(SwitcherProperties switcherProperties) {
        this.switcherProperties = switcherProperties;
    }

    protected boolean checkSnapshotVersion(ClientRemote clientRemote, Domain domain) {
        String environment = this.switcherProperties.getValue(ContextKey.ENVIRONMENT);
        SwitcherUtils.debug(logger, "verifying snapshot version - environment: {}", environment);
        return clientRemote.checkSnapshotVersion(domain.getVersion());
    }

    protected Domain initializeSnapshotFromAPI(ClientRemote clientRemote) throws SwitcherRemoteException, SwitcherSnapshotWriteException {
        String environment = this.switcherProperties.getValue(ContextKey.ENVIRONMENT);
        SwitcherUtils.debug(logger, "initializing snapshot from API - environment: {}", environment);
        Snapshot snapshot = clientRemote.resolveSnapshot();
        String snapshotLocation = this.switcherProperties.getValue(ContextKey.SNAPSHOT_LOCATION);
        if (Objects.nonNull(snapshotLocation)) {
            SnapshotLoader.saveSnapshot(snapshot, snapshotLocation, environment);
        }
        return snapshot.getDomain();
    }

    @Override
    public SwitcherProperties getSwitcherProperties() {
        return this.switcherProperties;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(Domain domain) {
        this.domain = domain;
    }
}

