/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.model;

import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.exception.SwitcherContextException;
import com.github.switcherapi.client.model.ContextKey;
import com.github.switcherapi.client.model.Entry;
import com.github.switcherapi.client.model.StrategyValidator;
import com.github.switcherapi.client.model.Switcher;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class SwitcherBuilder
implements Switcher {
    protected final SwitcherProperties properties;
    protected long delay;
    protected boolean remote;
    protected boolean bypassMetrics;
    protected String defaultResult;
    protected List<Entry> entry;

    protected SwitcherBuilder(SwitcherProperties properties) {
        this.properties = properties;
        this.entry = new ArrayList<Entry>();
        this.delay = 0L;
    }

    public SwitcherBuilder throttle(long delay) {
        this.delay = delay;
        return this;
    }

    public SwitcherBuilder remote(boolean remote) {
        if (!this.properties.getBoolean(ContextKey.LOCAL_MODE)) {
            throw new SwitcherContextException("Switcher is not configured to run locally");
        }
        this.remote = remote;
        return this;
    }

    public SwitcherBuilder defaultResult(boolean defaultResult) {
        this.defaultResult = String.valueOf(defaultResult);
        return this;
    }

    public SwitcherBuilder check(StrategyValidator strategy, String input) {
        if (StringUtils.isNotBlank((CharSequence)input)) {
            this.entry.add(Entry.build(strategy, input));
        }
        return this;
    }

    public SwitcherBuilder checkValue(String input) {
        return this.check(StrategyValidator.VALUE, input);
    }

    public SwitcherBuilder checkNumeric(String input) {
        return this.check(StrategyValidator.NUMERIC, input);
    }

    public SwitcherBuilder checkNetwork(String input) {
        return this.check(StrategyValidator.NETWORK, input);
    }

    public SwitcherBuilder checkRegex(String input) {
        return this.check(StrategyValidator.REGEX, input);
    }

    public SwitcherBuilder checkTime(String input) {
        return this.check(StrategyValidator.TIME, input);
    }

    public SwitcherBuilder checkDate(String input) {
        return this.check(StrategyValidator.DATE, input);
    }

    public SwitcherBuilder checkPayload(String input) {
        return this.check(StrategyValidator.PAYLOAD, input);
    }

    public SwitcherBuilder bypassMetrics() {
        this.bypassMetrics = true;
        return this;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public String getDefaultResult() {
        return this.defaultResult;
    }
}

