/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.model;

import com.github.switcherapi.client.SwitcherExecutor;
import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.exception.SwitcherException;
import com.github.switcherapi.client.model.AsyncSwitcher;
import com.github.switcherapi.client.model.Entry;
import com.github.switcherapi.client.model.SwitcherBuilder;
import com.github.switcherapi.client.model.SwitcherResult;
import com.github.switcherapi.client.test.SwitcherBypass;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class SwitcherRequest
extends SwitcherBuilder {
    public static final String KEY = "key";
    public static final String SHOW_REASON = "showReason";
    public static final String BYPASS_METRIC = "bypassMetric";
    private final SwitcherExecutor switcherExecutor;
    private final String switcherKey;
    private final Set<SwitcherResult> historyExecution;
    private AsyncSwitcher asyncSwitcher;

    public SwitcherRequest(String switcherKey, SwitcherExecutor switcherExecutor, SwitcherProperties switcherProperties) {
        super(switcherProperties);
        this.switcherExecutor = switcherExecutor;
        this.switcherKey = switcherKey;
        this.historyExecution = new HashSet<SwitcherResult>();
        this.entry = new ArrayList();
    }

    @Override
    public SwitcherRequest build() {
        return this;
    }

    @Override
    public SwitcherRequest prepareEntry(List<Entry> entry) {
        this.entry = Optional.ofNullable(entry).orElse(new ArrayList());
        return this;
    }

    @Override
    public SwitcherRequest prepareEntry(Entry entry, boolean add) {
        if (!add) {
            this.entry.clear();
        }
        if (!this.entry.contains(entry)) {
            this.entry.add(entry);
        }
        return this;
    }

    @Override
    public SwitcherRequest prepareEntry(Entry entry) {
        return this.prepareEntry(entry, false);
    }

    @Override
    public boolean isItOn() throws SwitcherException {
        SwitcherResult response = this.submit();
        return response.isItOn();
    }

    @Override
    public SwitcherResult submit() throws SwitcherException {
        Object response;
        if (SwitcherBypass.getBypass().containsKey(this.switcherKey)) {
            return SwitcherBypass.getBypass().get(this.switcherKey).buildFromSwitcher(this.switcherKey, this.entry);
        }
        if (this.canUseAsync()) {
            if (Objects.isNull(this.asyncSwitcher)) {
                this.asyncSwitcher = new AsyncSwitcher(this, this.delay);
            }
            this.asyncSwitcher.execute();
            response = this.getFromHistory();
            if (((Optional)response).isPresent()) {
                return (SwitcherResult)((Optional)response).get();
            }
        }
        response = this.switcherExecutor.executeCriteria(this);
        this.updateHistoryExecution((SwitcherResult)response);
        return response;
    }

    @Override
    public SwitcherResult executeCriteria() {
        return this.switcherExecutor.executeCriteria(this);
    }

    @Override
    public void updateHistoryExecution(SwitcherResult response) {
        this.historyExecution.removeIf(item -> this.switcherKey.equals(item.getSwitcherKey()) && this.entry.equals(item.getEntry()));
        this.historyExecution.add(response);
    }

    @Override
    public String getSwitcherKey() {
        return this.switcherKey;
    }

    @Override
    public List<Entry> getEntry() {
        return this.entry;
    }

    public boolean isBypassMetrics() {
        return this.bypassMetrics;
    }

    public void resetEntry() {
        this.entry = new ArrayList();
    }

    private boolean canUseAsync() {
        return this.delay > 0L && !this.historyExecution.isEmpty();
    }

    private Optional<SwitcherResult> getFromHistory() {
        for (SwitcherResult switcherResult : this.historyExecution) {
            if (!switcherResult.getEntry().equals(this.getEntry())) continue;
            return Optional.of(switcherResult);
        }
        return Optional.empty();
    }

    public String toString() {
        return String.format("SwitcherRequest [switcherKey= %s, entry= %s, bypassMetrics= %s]", this.switcherKey, this.entry, this.bypassMetrics);
    }
}

