/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.model;

import com.github.switcherapi.client.model.Entry;
import com.github.switcherapi.client.model.StrategyValidator;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SwitcherResult {
    public static final String DEFAULT_REASON = "Default result";
    public static final String DEFAULT_SUCCESS = "Success";
    private boolean result;
    private String reason;
    private Object metadata;
    private String switcherKey;
    protected List<Entry> entry;
    protected Map<String, List<String>> entryWhen = new HashMap<String, List<String>>();

    public SwitcherResult() {
        this.entry = new ArrayList<Entry>();
    }

    public SwitcherResult(String switcherKey, boolean result, String reason, List<Entry> entry) {
        this();
        this.result = result;
        this.reason = reason;
        this.switcherKey = switcherKey;
        this.entry = entry;
    }

    public SwitcherResult buildFromSwitcher(String switcherKey, List<Entry> entry) {
        this.switcherKey = switcherKey;
        this.entry = entry;
        if (Objects.nonNull(entry)) {
            for (Entry inputEntry : entry) {
                if (this.isEntryMatching(inputEntry)) continue;
                return new SwitcherResult(switcherKey, !this.result, this.reason, entry);
            }
        }
        return this;
    }

    private boolean isEntryMatching(Entry inputEntry) {
        return this.entryWhen.isEmpty() || this.entryWhen.containsKey(inputEntry.getStrategy()) && this.entryWhen.get(inputEntry.getStrategy()).contains(inputEntry.getInput());
    }

    public boolean isItOn() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public <T> T getMetadata(Class<T> clazz) {
        Gson gson = new Gson();
        return (T)gson.fromJson(gson.toJson(this.metadata), clazz);
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public String getSwitcherKey() {
        return this.switcherKey;
    }

    public void setSwitcherKey(String switcherKey) {
        this.switcherKey = switcherKey;
    }

    public List<Entry> getEntry() {
        return this.entry;
    }

    public void setEntry(List<Entry> entry) {
        this.entry = entry;
    }

    public SwitcherResult when(StrategyValidator strategy, String input) {
        return this.when(strategy, List.of(input));
    }

    public SwitcherResult when(StrategyValidator strategy, List<String> inputs) {
        this.entryWhen.put(strategy.toString(), inputs);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.entry, this.result, this.switcherKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwitcherResult other = (SwitcherResult)obj;
        return Objects.equals(this.entry, other.entry) && this.result == other.result && Objects.equals(this.switcherKey, other.switcherKey);
    }

    public String toString() {
        return "SwitcherResult [result=" + this.result + ", reason=" + this.reason + ", metadata=" + this.metadata + ", switcherKey=" + this.switcherKey + ", entry=" + this.entry + "]";
    }
}

