/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.remote;

import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.exception.SwitcherException;
import com.github.switcherapi.client.model.ContextKey;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.security.KeyStore;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;

public class ClientWSBuilder {
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String PROTOCOL = "TLSv1.2";

    private ClientWSBuilder() {
        throw new IllegalStateException("Utility class");
    }

    public static HttpClient.Builder builder(ExecutorService executorService, SwitcherProperties switcherProperties) {
        if (StringUtils.isNotBlank((CharSequence)switcherProperties.getValue(ContextKey.TRUSTSTORE_PATH))) {
            return ClientWSBuilder.builderSSL(executorService, switcherProperties);
        }
        return HttpClient.newBuilder().executor(executorService);
    }

    private static HttpClient.Builder builderSSL(ExecutorService executorService, SwitcherProperties switcherProperties) {
        HttpClient.Builder builder;
        FileInputStream readStream = new FileInputStream(switcherProperties.getValue(ContextKey.TRUSTSTORE_PATH));
        try {
            KeyStore trustStore = KeyStore.getInstance(KEYSTORE_TYPE);
            trustStore.load(readStream, switcherProperties.getValue(ContextKey.TRUSTSTORE_PASSWORD).toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            builder = HttpClient.newBuilder().sslContext(sslContext).executor(executorService);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)readStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SwitcherException("Error while building SSL context", e);
            }
        }
        ((InputStream)readStream).close();
        return builder;
    }
}

