/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.remote;

import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.exception.SwitcherRemoteException;
import com.github.switcherapi.client.model.ContextKey;
import com.github.switcherapi.client.model.criteria.Snapshot;
import com.github.switcherapi.client.remote.ClientWS;
import com.github.switcherapi.client.remote.ClientWSBuilder;
import com.github.switcherapi.client.remote.dto.AuthRequest;
import com.github.switcherapi.client.remote.dto.AuthResponse;
import com.github.switcherapi.client.remote.dto.CriteriaRequest;
import com.github.switcherapi.client.remote.dto.CriteriaResponse;
import com.github.switcherapi.client.remote.dto.SnapshotVersionResponse;
import com.github.switcherapi.client.remote.dto.SwitchersCheck;
import com.google.gson.Gson;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class ClientWSImpl
implements ClientWS {
    private final SwitcherProperties switcherProperties;
    private final HttpClient client;
    private final int timeoutMs;
    private final Gson gson = new Gson();

    public ClientWSImpl(SwitcherProperties switcherProperties, HttpClient client, int timeoutMs) {
        this.switcherProperties = switcherProperties;
        this.timeoutMs = timeoutMs;
        this.client = client;
    }

    public static ClientWS build(SwitcherProperties switcherProperties, ExecutorService executorService, int timeoutMs) {
        HttpClient httpClient = ClientWSBuilder.builder(executorService, switcherProperties).connectTimeout(Duration.ofMillis(timeoutMs)).build();
        return new ClientWSImpl(switcherProperties, httpClient, timeoutMs);
    }

    @Override
    public CriteriaResponse executeCriteria(CriteriaRequest criteriaRequest, String token) {
        String url = this.switcherProperties.getValue(ContextKey.URL);
        try {
            URI uri = new URI(url).resolve(String.format("%s/criteria?%s=%s&%s=%s&%s=%s", url, "key", criteriaRequest.getSwitcherKey(), "showReason", Boolean.TRUE, "bypassMetric", criteriaRequest.isBypassMetric()));
            HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(uri).headers("Authorization", String.format("Bearer %s", token), "Content-Type", "application/json").timeout(Duration.ofMillis(this.timeoutMs)).POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson((Object)criteriaRequest.getInputRequest()))).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new SwitcherRemoteException(url, response.statusCode());
            }
            CriteriaResponse criteriaResponse = (CriteriaResponse)this.gson.fromJson(response.body(), CriteriaResponse.class);
            criteriaResponse.setSwitcherKey(criteriaRequest.getSwitcherKey());
            return criteriaResponse;
        }
        catch (Exception e) {
            return (CriteriaResponse)this.exceptionHandler(e, url);
        }
    }

    @Override
    public Optional<AuthResponse> auth() {
        AuthRequest authRequest = new AuthRequest();
        authRequest.setDomain(this.switcherProperties.getValue(ContextKey.DOMAIN));
        authRequest.setComponent(this.switcherProperties.getValue(ContextKey.COMPONENT));
        authRequest.setEnvironment(this.switcherProperties.getValue(ContextKey.ENVIRONMENT));
        String url = this.switcherProperties.getValue(ContextKey.URL);
        try {
            HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(URI.create(String.format("%s/criteria/auth", url))).headers("switcher-api-key", this.switcherProperties.getValue(ContextKey.APIKEY), "Content-Type", "application/json").timeout(Duration.ofMillis(this.timeoutMs)).POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson((Object)authRequest))).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new SwitcherRemoteException(url, response.statusCode());
            }
            return Optional.of((AuthResponse)this.gson.fromJson(response.body(), AuthResponse.class));
        }
        catch (Exception e) {
            return (Optional)this.exceptionHandler(e, url);
        }
    }

    @Override
    public Snapshot resolveSnapshot(String token) {
        String url = this.switcherProperties.getValue(ContextKey.URL);
        try {
            HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(URI.create(String.format("%s/graphql", url))).headers("Authorization", String.format("Bearer %s", token), "Content-Type", "application/json").timeout(Duration.ofMillis(this.timeoutMs)).POST(HttpRequest.BodyPublishers.ofString(String.format("{\"query\":\"{ domain(name: \\\"%s\\\", environment: \\\"%s\\\", _component: \\\"%s\\\") { name version description activated group { name description activated config { key description activated strategies { strategy activated operation values } components } } } }\"}", this.switcherProperties.getValue(ContextKey.DOMAIN), this.switcherProperties.getValue(ContextKey.ENVIRONMENT), this.switcherProperties.getValue(ContextKey.COMPONENT)))).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new SwitcherRemoteException(url, response.statusCode());
            }
            return (Snapshot)this.gson.fromJson(response.body(), Snapshot.class);
        }
        catch (Exception e) {
            return (Snapshot)this.exceptionHandler(e, url);
        }
    }

    @Override
    public SnapshotVersionResponse checkSnapshotVersion(long version, String token) {
        String url = this.switcherProperties.getValue(ContextKey.URL);
        try {
            HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(URI.create(String.format("%s/criteria/snapshot_check/%s", url, version))).headers("Authorization", String.format("Bearer %s", token), "Content-Type", "application/json").timeout(Duration.ofMillis(this.timeoutMs)).GET().build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new SwitcherRemoteException(url, response.statusCode());
            }
            return (SnapshotVersionResponse)this.gson.fromJson(response.body(), SnapshotVersionResponse.class);
        }
        catch (Exception e) {
            return (SnapshotVersionResponse)this.exceptionHandler(e, url);
        }
    }

    @Override
    public boolean isAlive() {
        try {
            HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(URI.create(String.format("%s/check", this.switcherProperties.getValue(ContextKey.URL)))).timeout(Duration.ofMillis(this.timeoutMs)).GET().build(), HttpResponse.BodyHandlers.ofString());
            return response.statusCode() == 200;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public SwitchersCheck checkSwitchers(Set<String> switchers, String token) {
        String url = this.switcherProperties.getValue(ContextKey.URL);
        try {
            HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(URI.create(String.format("%s/criteria/switchers_check", url))).timeout(Duration.ofMillis(this.timeoutMs)).headers("Authorization", String.format("Bearer %s", token), "Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(this.gson.toJson((Object)new SwitchersCheck(switchers)))).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new SwitcherRemoteException(url, response.statusCode());
            }
            return (SwitchersCheck)this.gson.fromJson(response.body(), SwitchersCheck.class);
        }
        catch (Exception e) {
            return (SwitchersCheck)this.exceptionHandler(e, url);
        }
    }

    private <T> T exceptionHandler(Exception e, String url) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        throw new SwitcherRemoteException(url, e);
    }
}

