/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.service;

import com.github.switcherapi.client.exception.SwitcherInvalidStrategyException;
import com.github.switcherapi.client.model.Entry;
import com.github.switcherapi.client.model.StrategyValidator;
import com.github.switcherapi.client.model.criteria.Strategy;
import com.github.switcherapi.client.service.SwitcherValidator;
import com.github.switcherapi.client.service.validators.DateValidator;
import com.github.switcherapi.client.service.validators.NetworkValidator;
import com.github.switcherapi.client.service.validators.NumericValidator;
import com.github.switcherapi.client.service.validators.PayloadValidator;
import com.github.switcherapi.client.service.validators.RegexValidator;
import com.github.switcherapi.client.service.validators.TimeValidator;
import com.github.switcherapi.client.service.validators.Validator;
import com.github.switcherapi.client.service.validators.ValueValidator;
import java.util.EnumMap;

public class ValidatorService
implements SwitcherValidator {
    private final EnumMap<StrategyValidator, Validator> validators = new EnumMap(StrategyValidator.class);

    public ValidatorService() {
        this.initializeValidators();
    }

    private void initializeValidators() {
        this.registerValidator(new DateValidator());
        this.registerValidator(new NetworkValidator());
        this.registerValidator(new NumericValidator());
        this.registerValidator(new PayloadValidator());
        this.registerValidator(new TimeValidator());
        this.registerValidator(new ValueValidator());
        this.registerValidator(new RegexValidator());
    }

    @Override
    public void registerValidator(Validator validator) {
        this.validators.put(validator.getType(), validator);
    }

    @Override
    public boolean execute(Strategy strategy, Entry switcherInput) throws SwitcherInvalidStrategyException {
        if (!this.validators.containsKey((Object)strategy.getStrategyValidator())) {
            throw new SwitcherInvalidStrategyException(strategy.getStrategy());
        }
        return this.validators.get((Object)strategy.getStrategyValidator()).execute(strategy, switcherInput);
    }
}

