/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.service.local;

import com.github.switcherapi.client.exception.SwitcherKeyNotFoundException;
import com.github.switcherapi.client.model.Entry;
import com.github.switcherapi.client.model.SwitcherRequest;
import com.github.switcherapi.client.model.SwitcherResult;
import com.github.switcherapi.client.model.criteria.Config;
import com.github.switcherapi.client.model.criteria.Domain;
import com.github.switcherapi.client.model.criteria.Group;
import com.github.switcherapi.client.model.criteria.Strategy;
import com.github.switcherapi.client.service.SwitcherFactory;
import com.github.switcherapi.client.service.SwitcherValidator;
import com.github.switcherapi.client.service.local.ClientLocal;
import com.github.switcherapi.client.utils.SwitcherUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLocalService
implements ClientLocal {
    private static final Logger logger = LoggerFactory.getLogger(ClientLocalService.class);
    public static final String DISABLED_DOMAIN = "Domain disabled";
    public static final String DISABLED_GROUP = "Group disabled";
    public static final String DISABLED_CONFIG = "Config disabled";
    private static final String STRATEGY_FAIL_PATTERN = "Strategy %s does not agree";
    private static final String STRATEGY_FAIL_NO_INPUT_PATTERN = "Strategy %s did not receive any input";
    private static final String LOG_PROCESS_OP_TEMPLATE = "processOperation: configStrategies: {}";
    private final SwitcherValidator validatorService;

    public ClientLocalService(SwitcherValidator validatorService) {
        this.validatorService = validatorService;
    }

    @Override
    public List<String> checkSwitchers(Set<String> switchers, Domain domain) {
        ArrayList<String> notFound = new ArrayList<String>();
        for (String switcher : switchers) {
            if (!Arrays.stream(domain.getGroup()).noneMatch(group -> Arrays.stream(group.getConfig()).anyMatch(config -> config.getKey().equals(switcher)))) continue;
            notFound.add(switcher);
        }
        return notFound;
    }

    @Override
    public SwitcherResult executeCriteria(SwitcherRequest switcher, Domain domain) {
        if (!domain.isActivated()) {
            return SwitcherFactory.buildResultFail(DISABLED_DOMAIN, switcher);
        }
        for (Group group : domain.getGroup()) {
            Config config = this.findConfigInGroup(group, switcher.getSwitcherKey());
            if (config == null) continue;
            return this.getSwitcherResult(switcher, group, config);
        }
        throw new SwitcherKeyNotFoundException(switcher.getSwitcherKey());
    }

    private SwitcherResult getSwitcherResult(SwitcherRequest switcher, Group group, Config config) {
        if (!group.isActivated()) {
            return SwitcherFactory.buildResultFail(DISABLED_GROUP, switcher);
        }
        if (!config.isActivated()) {
            return SwitcherFactory.buildResultFail(DISABLED_CONFIG, switcher);
        }
        if (ArrayUtils.isNotEmpty((Object[])config.getStrategies())) {
            return this.processOperation(config.getStrategies(), switcher.getEntry(), switcher);
        }
        return SwitcherFactory.buildResultSuccess(switcher);
    }

    private Config findConfigInGroup(Group group, String switcherKey) {
        return Arrays.stream(group.getConfig()).filter(c -> c.getKey().equals(switcherKey)).findFirst().orElse(null);
    }

    private SwitcherResult processOperation(Strategy[] configStrategies, List<Entry> input, SwitcherRequest switcher) {
        SwitcherUtils.debug(logger, LOG_PROCESS_OP_TEMPLATE, Arrays.toString(configStrategies));
        for (Strategy strategy : configStrategies) {
            if (!strategy.isActivated()) continue;
            Entry switcherInput = this.tryGetSwitcherInput(input, strategy);
            if (switcherInput == null) {
                return this.strategyFailed(switcher, strategy, STRATEGY_FAIL_NO_INPUT_PATTERN);
            }
            if (this.validatorService.execute(strategy, switcherInput)) continue;
            return this.strategyFailed(switcher, strategy, STRATEGY_FAIL_PATTERN);
        }
        return SwitcherFactory.buildResultSuccess(switcher);
    }

    private SwitcherResult strategyFailed(SwitcherRequest switcher, Strategy strategy, String pattern) {
        return SwitcherFactory.buildResultFail(String.format(pattern, strategy.getStrategy()), switcher);
    }

    private Entry tryGetSwitcherInput(List<Entry> input, Strategy strategy) {
        if (input == null) {
            return null;
        }
        return input.stream().filter(i -> i.getStrategy().equals(strategy.getStrategy())).findFirst().orElse(null);
    }
}

