/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.service.validators;

import com.github.switcherapi.client.exception.SwitcherInvalidOperationException;
import com.github.switcherapi.client.model.Entry;
import com.github.switcherapi.client.model.StrategyValidator;
import com.github.switcherapi.client.model.criteria.Strategy;
import com.github.switcherapi.client.service.validators.Validator;
import org.apache.commons.net.util.SubnetUtils;

public class NetworkValidator
extends Validator {
    public static final String CIDR_REGEX = "^(\\d{1,3}\\.){3}\\d{1,3}(/(\\d|[1-2]\\d|3[0-2]))";

    @Override
    public StrategyValidator getType() {
        return StrategyValidator.NETWORK;
    }

    @Override
    public boolean process(Strategy strategy, Entry switcherInput) {
        switch (strategy.getEntryOperation()) {
            case EXIST: {
                return this.verifyIfAddressExistInNetwork(strategy, switcherInput);
            }
            case NOT_EXIST: {
                return !this.verifyIfAddressExistInNetwork(strategy, switcherInput);
            }
        }
        throw new SwitcherInvalidOperationException(strategy.getOperation(), strategy.getStrategy());
    }

    private boolean verifyIfAddressExistInNetwork(Strategy strategy, Entry switcherInput) {
        for (String value : strategy.getValues()) {
            SubnetUtils.SubnetInfo subnetInfo;
            if (!(value.matches(CIDR_REGEX) ? (subnetInfo = new SubnetUtils(value).getInfo()).isInRange(switcherInput.getInput()) : value.equals(switcherInput.getInput()))) continue;
            return true;
        }
        return false;
    }
}

