/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.service.validators;

import com.github.switcherapi.client.exception.SwitcherException;
import com.github.switcherapi.client.model.Entry;
import com.github.switcherapi.client.model.StrategyValidator;
import com.github.switcherapi.client.model.criteria.Strategy;
import com.github.switcherapi.client.utils.SwitcherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Validator {
    protected static final Logger logger = LoggerFactory.getLogger(Validator.class);
    public static final String DEBUG_SWITCHER_INPUT = "switcherInput: {}";
    public static final String DEBUG_STRATEGY = "strategy: {}";

    public boolean execute(Strategy strategy, Entry switcherInput) throws SwitcherException {
        SwitcherUtils.debug(logger, DEBUG_STRATEGY, strategy);
        SwitcherUtils.debug(logger, DEBUG_SWITCHER_INPUT, switcherInput);
        return this.process(strategy, switcherInput);
    }

    public abstract boolean process(Strategy var1, Entry var2) throws SwitcherException;

    public abstract StrategyValidator getType();
}

