/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.utils;

import com.github.switcherapi.client.exception.SwitcherSnapshotLoadException;
import com.github.switcherapi.client.exception.SwitcherSnapshotWriteException;
import com.github.switcherapi.client.model.criteria.Domain;
import com.github.switcherapi.client.model.criteria.Snapshot;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class SnapshotLoader {
    private static final String SNAPSHOT_FILE_FORMAT = "%s/%s.json";
    private static final Gson gson = new Gson();

    private SnapshotLoader() {
    }

    public static Domain loadSnapshot(String snapshotFile) throws SwitcherSnapshotLoadException {
        Domain domain;
        FileReader fileReader = new FileReader(snapshotFile);
        try {
            Snapshot data = (Snapshot)gson.fromJson((Reader)fileReader, Snapshot.class);
            domain = data.getDomain();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                throw new SwitcherSnapshotLoadException(snapshotFile, (Exception)e);
            }
        }
        fileReader.close();
        return domain;
    }

    public static Domain loadSnapshot(String snapshotLocation, String environment) throws SwitcherSnapshotLoadException, IOException {
        Domain domain;
        String path = String.format(SNAPSHOT_FILE_FORMAT, snapshotLocation, environment);
        FileReader fileReader = new FileReader(path);
        try {
            Snapshot data = (Snapshot)gson.fromJson((Reader)fileReader, Snapshot.class);
            domain = data.getDomain();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIOException | JsonSyntaxException e) {
                throw new SwitcherSnapshotLoadException(String.format(SNAPSHOT_FILE_FORMAT, snapshotLocation, environment), (Exception)e);
            }
            catch (FileNotFoundException e) {
                return SnapshotLoader.loadSnapshotFromResources(snapshotLocation, environment);
            }
        }
        fileReader.close();
        return domain;
    }

    private static Domain loadSnapshotFromResources(String snapshotLocation, String environment) throws SwitcherSnapshotLoadException, IOException {
        String path = String.format(SNAPSHOT_FILE_FORMAT, snapshotLocation, environment);
        try (InputStream is = SnapshotLoader.class.getResourceAsStream(path);){
            Domain domain;
            if (Objects.isNull(is)) {
                throw new FileNotFoundException(path);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            try {
                Snapshot data = (Snapshot)gson.fromJson((Reader)reader, Snapshot.class);
                domain = data.getDomain();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    throw new SwitcherSnapshotLoadException(String.format(SNAPSHOT_FILE_FORMAT, snapshotLocation, environment), (Exception)e);
                }
            }
            reader.close();
            return domain;
        }
    }

    public static void saveSnapshot(Snapshot snapshot, String snapshotLocation, String environment) throws SwitcherSnapshotWriteException {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Path path = Paths.get(snapshotLocation, new String[0]);
            if (!path.toFile().exists()) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            throw new SwitcherSnapshotWriteException(String.format(SNAPSHOT_FILE_FORMAT, snapshotLocation, environment), e);
        }
        try (FileWriter fileWriter = new FileWriter(String.format(SNAPSHOT_FILE_FORMAT, snapshotLocation, environment));
             BufferedWriter bw = new BufferedWriter(fileWriter);
             PrintWriter wr = new PrintWriter(bw);){
            wr.write(gson.toJson((Object)snapshot));
        }
        catch (Exception e) {
            throw new SwitcherSnapshotWriteException(String.format(SNAPSHOT_FILE_FORMAT, snapshotLocation, environment), e);
        }
    }
}

