/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.utils;

import com.github.switcherapi.client.service.local.SwitcherLocalService;
import com.github.switcherapi.client.utils.SnapshotEventHandler;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotWatcher
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotWatcher.class);
    private final SnapshotEventHandler handler;
    private final String snapshotLocation;
    private WatchService watcher;
    private SwitcherLocalService executorInstance;

    public SnapshotWatcher(SwitcherLocalService executorInstance, SnapshotEventHandler handler, String snapshotLocation) {
        this.executorInstance = executorInstance;
        this.handler = handler;
        this.snapshotLocation = snapshotLocation;
    }

    @Override
    public void run() {
        try {
            WatchKey key;
            this.watcher = FileSystems.getDefault().newWatchService();
            Path dir = Paths.get(this.snapshotLocation, new String[0]);
            dir.register(this.watcher, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            do {
                key = this.watcher.take();
                Thread.sleep(1000L);
                Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                while (iterator.hasNext()) {
                    WatchEvent<?> event;
                    WatchEvent<?> ev = event = iterator.next();
                    Path filename = (Path)ev.context();
                    if (this.executorInstance == null) continue;
                    this.executorInstance.notifyChange(filename.toString(), this.handler);
                }
            } while (key.reset());
        }
        catch (IOException | InterruptedException | ClosedWatchServiceException e) {
            Thread.currentThread().interrupt();
            this.executorInstance = null;
        }
    }

    public void terminate() {
        try {
            if (this.watcher != null) {
                this.watcher.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

