/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.utils;

import com.github.switcherapi.client.exception.SwitcherContextException;
import com.github.switcherapi.client.exception.SwitcherInvalidDateTimeArgumentException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;

public class SwitcherUtils {
    private static final String[] DURATION_UNIT = new String[]{"s", "m", "h", "d"};
    private static final String ENV_VARIABLE_PATTERN = "\\$\\{(\\w+)}";
    private static final String ENV_DEFAULT_VARIABLE_PATTERN = "\\$\\{(\\w+):(.+)?}";
    private static final String PAYLOAD_PATTERN = "%s.%s";

    private SwitcherUtils() {
    }

    public static Date addTimeDuration(String addValue, Date date) throws SwitcherInvalidDateTimeArgumentException {
        switch (addValue.charAt(addValue.length() - 1)) {
            case 's': {
                return DateUtils.addSeconds((Date)date, (int)Integer.parseInt(addValue.replace(DURATION_UNIT[0], "")));
            }
            case 'm': {
                return DateUtils.addMinutes((Date)date, (int)Integer.parseInt(addValue.replace(DURATION_UNIT[1], "")));
            }
            case 'h': {
                return DateUtils.addHours((Date)date, (int)Integer.parseInt(addValue.replace(DURATION_UNIT[2], "")));
            }
            case 'd': {
                return DateUtils.addDays((Date)date, (int)Integer.parseInt(addValue.replace(DURATION_UNIT[3], "")));
            }
        }
        throw new SwitcherInvalidDateTimeArgumentException(addValue);
    }

    public static long getMillis(String time) {
        switch (time.charAt(time.length() - 1)) {
            case 's': {
                return (long)(Double.parseDouble(time.replace(DURATION_UNIT[0], "")) * 1000.0);
            }
            case 'm': {
                return (long)(Double.parseDouble(time.replace(DURATION_UNIT[1], "")) * 60000.0);
            }
        }
        throw new SwitcherInvalidDateTimeArgumentException(time);
    }

    public static Set<String> payloadReader(String jsonStr, String prevKey) {
        JsonElement parser = JsonParser.parseString((String)jsonStr);
        JsonObject jsonObject = parser.getAsJsonObject();
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = Objects.isNull(prevKey) ? (String)entry.getKey() : String.format(PAYLOAD_PATTERN, prevKey, entry.getKey());
            keys.add(key);
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                keys.addAll(SwitcherUtils.payloadReader(((JsonElement)entry.getValue()).toString(), key));
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonArray() || !((JsonElement)entry.getValue()).getAsJsonArray().get(0).isJsonObject()) continue;
            ((JsonElement)entry.getValue()).getAsJsonArray().forEach(eValue -> keys.addAll(SwitcherUtils.payloadReader(eValue.toString(), key)));
        }
        return keys;
    }

    public static String resolveProperties(String key, Properties prop) {
        String value = prop.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        Object[] sBuilder = SwitcherUtils.resolveEnvironmentVariable(value);
        if (sBuilder[1].equals(Boolean.FALSE) && sBuilder[0].toString().isEmpty()) {
            return value;
        }
        return sBuilder[0].toString();
    }

    public static void debug(Logger logger, String message, Object ... args) {
        logger.debug(message, args);
    }

    private static Object[] resolveEnvironmentVariable(String value) {
        Pattern pattern = Pattern.compile(ENV_VARIABLE_PATTERN);
        Matcher matcher = pattern.matcher(value);
        StringBuilder sBuilder = new StringBuilder();
        if (matcher.find()) {
            if (SwitcherUtils.setWithSystemEnv(matcher, sBuilder)) {
                throw new SwitcherContextException(String.format("Property %s not defined", value));
            }
        } else {
            pattern = Pattern.compile(ENV_DEFAULT_VARIABLE_PATTERN);
            matcher = pattern.matcher(value);
            if (matcher.find() && SwitcherUtils.setWithSystemEnv(matcher, sBuilder)) {
                if (Objects.nonNull(matcher.group(2))) {
                    sBuilder.append(matcher.group(2));
                    return new Object[]{sBuilder.toString(), Boolean.TRUE};
                }
                if (Objects.nonNull(matcher.group(1))) {
                    return new Object[]{"", Boolean.TRUE};
                }
            }
        }
        return new Object[]{sBuilder.toString(), Boolean.FALSE};
    }

    private static boolean setWithSystemEnv(Matcher matcher, StringBuilder sBuilder) {
        String envVarName = matcher.group(1);
        if (Objects.nonNull(envVarName)) {
            sBuilder.append(Optional.ofNullable(System.getenv(envVarName)).orElse(""));
        }
        return StringUtils.isEmpty((CharSequence)sBuilder.toString());
    }
}

