package com.github.switcherapi.client.model;

/**
 * Contains required and optional properties to build the context
 * 
 * @author Roger Floriano {petruki)
 * @since 2022-06-19
 */
public enum ContextKey {
	
	/**
	 *  (String) Switcher API URL.
	 */
	URL("switcher.url"),
	
	/**
	 * (String) API Key generated by your domain.
	 */
	APIKEY("switcher.apikey"),
	
	/**
	 * (String) Registered domain name.
	 */
	DOMAIN("switcher.domain"),
	
	/**
	 * (String) Name of this application. This value is used to track which applications are using switchers.
	 */
	COMPONENT("switcher.component"),
	
	/**
	 * (String) Name of the environment where this application is running ('default' is a production environment).
	 */
	ENVIRONMENT("switcher.environment"),
	
	/**
	 * (String) Folder path where all snapshot files are located.
	 */
	SNAPSHOT_LOCATION("switcher.snapshot.location"),
	
	/**
	 * (String) Defines the package and class where a context wrapper is located.
	 * It is only necessary to use with {@link com.github.switcherapi.client.SwitcherContext}
	 */
	CONTEXT_LOCATION("switcher.context"),
	
	/**
	 * (boolean) Activate snapshot autoload which will try to retrieve the snapshot from the API if the file does not exist.
	 */
	SNAPSHOT_AUTO_LOAD("switcher.snapshot.auto"),
	
	/**
	 * (boolean) When true it will skip validateSnapshot() (default is false)
	 */
	SNAPSHOT_SKIP_VALIDATION("switcher.snapshot.skipvalidation"),

	/**
	 * (String) Interval given to the library to update the snapshot
	 */
	SNAPSHOT_AUTO_UPDATE_INTERVAL("switcher.snapshot.updateinterval"),
	
	/**
	 * (String) Defines if client will work in silent mode by specifying the time interval to retry
	 */
	SILENT_MODE("switcher.silent"),
	
	/**
	 * (boolean) Defines if client will work locally.
	 */
	LOCAL_MODE("switcher.local"),

	/**
	 * (Number) Defines the Timed Match regex time out.
	 */
	REGEX_TIMEOUT("switcher.regextimeout"),

	/**
	 * (Path) Defines the path for the truststore file.
	 */
	TRUSTSTORE_PATH("switcher.truststore.path"),

	/**
	 * (String) Defines the password for the truststore file.
	 */
	TRUSTSTORE_PASSWORD("switcher.truststore.password"),

	/**
	 * (Number) Defines the timeout in ms for the Remote client (default is 3000).
	 */
	TIMEOUT_MS("switcher.timeout"),

	/**
	 * (Number) Defines a fixed number of threads for the pool connection (default is 2).
	 */
	POOL_CONNECTION_SIZE("switcher.poolsize");
	
	private final String param;
	
	ContextKey(String param) {
		this.param = param;
	}

	public String getParam() {
		return param;
	}
	
}
