/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client;

import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.SwitcherPropertiesImpl;
import com.github.switcherapi.client.model.ContextKey;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ContextBuilder {
    private static ContextBuilder context;
    private SwitcherProperties switcherProperties;

    private ContextBuilder(SwitcherProperties switcherProperties) {
        this.switcherProperties = switcherProperties;
    }

    public static void preConfigure(SwitcherProperties switcherProperties) {
        context = ContextBuilder.builder();
        context.preBuild(switcherProperties);
    }

    public static ContextBuilder builder() {
        context = ContextBuilder.builder(false);
        return context;
    }

    public static ContextBuilder builder(boolean init) {
        if (context == null || init) {
            context = new ContextBuilder(new SwitcherPropertiesImpl());
        }
        return context;
    }

    void preBuild(SwitcherProperties properties) {
        this.switcherProperties = properties;
    }

    SwitcherProperties build() {
        return this.switcherProperties;
    }

    public ContextBuilder context(String context) {
        this.switcherProperties.setValue(ContextKey.CONTEXT_LOCATION, context);
        return this;
    }

    public ContextBuilder url(String url) {
        this.switcherProperties.setValue(ContextKey.URL, url);
        return this;
    }

    public ContextBuilder apiKey(String apiKey) {
        this.switcherProperties.setValue(ContextKey.APIKEY, apiKey);
        return this;
    }

    public ContextBuilder domain(String domain) {
        this.switcherProperties.setValue(ContextKey.DOMAIN, domain);
        return this;
    }

    public ContextBuilder component(String component) {
        this.switcherProperties.setValue(ContextKey.COMPONENT, component);
        return this;
    }

    public ContextBuilder environment(String environment) {
        this.switcherProperties.setValue(ContextKey.ENVIRONMENT, Optional.ofNullable(environment).orElse("default"));
        return this;
    }

    public ContextBuilder snapshotLocation(String snapshotLocation) {
        this.switcherProperties.setValue(ContextKey.SNAPSHOT_LOCATION, snapshotLocation);
        return this;
    }

    public ContextBuilder snapshotAutoUpdateInterval(String snapshotAutoUpdateInterval) {
        this.switcherProperties.setValue(ContextKey.SNAPSHOT_AUTO_UPDATE_INTERVAL, snapshotAutoUpdateInterval);
        if (snapshotAutoUpdateInterval != null) {
            this.switcherProperties.setValue(ContextKey.SNAPSHOT_AUTO_LOAD, true);
        }
        return this;
    }

    public ContextBuilder snapshotAutoLoad(boolean snapshotAutoLoad) {
        this.switcherProperties.setValue(ContextKey.SNAPSHOT_AUTO_LOAD, snapshotAutoLoad);
        return this;
    }

    public ContextBuilder snapshotSkipValidation(boolean snapshotSkipValidation) {
        this.switcherProperties.setValue(ContextKey.SNAPSHOT_SKIP_VALIDATION, snapshotSkipValidation);
        return this;
    }

    public ContextBuilder snapshotWatcher(boolean snapshotWatcher) {
        this.switcherProperties.setValue(ContextKey.SNAPSHOT_WATCHER, snapshotWatcher);
        return this;
    }

    public ContextBuilder silentMode(String retryAfter) {
        this.switcherProperties.setValue(ContextKey.SILENT_MODE, retryAfter);
        if (StringUtils.isNotBlank((CharSequence)retryAfter)) {
            this.switcherProperties.setValue(ContextKey.SNAPSHOT_AUTO_LOAD, true);
        }
        return this;
    }

    public ContextBuilder local(boolean local) {
        this.switcherProperties.setValue(ContextKey.LOCAL_MODE, local);
        return this;
    }

    public ContextBuilder checkSwitchers(boolean checkSwitchers) {
        this.switcherProperties.setValue(ContextKey.CHECK_SWITCHERS, checkSwitchers);
        return this;
    }

    public ContextBuilder restrictRelay(boolean restrictRelay) {
        this.switcherProperties.setValue(ContextKey.RESTRICT_RELAY, restrictRelay);
        return this;
    }

    public ContextBuilder truststorePath(String truststorePath) {
        this.switcherProperties.setValue(ContextKey.TRUSTSTORE_PATH, truststorePath);
        return this;
    }

    public ContextBuilder truststorePassword(String truststorePassword) {
        this.switcherProperties.setValue(ContextKey.TRUSTSTORE_PASSWORD, truststorePassword);
        return this;
    }

    public ContextBuilder timeoutMs(Integer timeoutMs) {
        this.switcherProperties.setValue(ContextKey.TIMEOUT_MS, Optional.ofNullable(timeoutMs).orElse(3000));
        return this;
    }

    public ContextBuilder poolConnectionSize(Integer poolSize) {
        this.switcherProperties.setValue(ContextKey.POOL_CONNECTION_SIZE, Optional.ofNullable(poolSize).orElse(2));
        return this;
    }
}

