/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client;

import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.model.ContextKey;

abstract class SwitcherConfig {
    protected String url;
    protected String apikey;
    protected String domain;
    protected String component;
    protected String environment;
    protected boolean local;
    protected boolean check;
    protected String silent;
    protected Integer timeout;
    protected Integer poolSize;
    protected RelayConfig relay = new RelayConfig();
    protected SnapshotConfig snapshot = new SnapshotConfig();
    protected TruststoreConfig truststore = new TruststoreConfig();

    SwitcherConfig() {
    }

    protected void updateSwitcherConfig(SwitcherProperties properties) {
        this.setUrl(properties.getValue(ContextKey.URL));
        this.setApikey(properties.getValue(ContextKey.APIKEY));
        this.setDomain(properties.getValue(ContextKey.DOMAIN));
        this.setComponent(properties.getValue(ContextKey.COMPONENT));
        this.setEnvironment(properties.getValue(ContextKey.ENVIRONMENT));
        this.setLocal(properties.getBoolean(ContextKey.LOCAL_MODE));
        this.setCheck(properties.getBoolean(ContextKey.CHECK_SWITCHERS));
        this.setSilent(properties.getValue(ContextKey.SILENT_MODE));
        this.setTimeout(properties.getInt(ContextKey.TIMEOUT_MS));
        this.setPoolSize(properties.getInt(ContextKey.POOL_CONNECTION_SIZE));
        RelayConfig relayConfig = new RelayConfig();
        relayConfig.setRestrict(properties.getBoolean(ContextKey.RESTRICT_RELAY));
        this.setRelay(relayConfig);
        SnapshotConfig snapshotConfig = new SnapshotConfig();
        snapshotConfig.setLocation(properties.getValue(ContextKey.SNAPSHOT_LOCATION));
        snapshotConfig.setAuto(properties.getBoolean(ContextKey.SNAPSHOT_AUTO_LOAD));
        snapshotConfig.setSkipValidation(properties.getBoolean(ContextKey.SNAPSHOT_SKIP_VALIDATION));
        snapshotConfig.setWatcher(properties.getBoolean(ContextKey.SNAPSHOT_WATCHER));
        snapshotConfig.setUpdateInterval(properties.getValue(ContextKey.SNAPSHOT_AUTO_UPDATE_INTERVAL));
        this.setSnapshot(snapshotConfig);
        TruststoreConfig truststoreConfig = new TruststoreConfig();
        truststoreConfig.setPath(properties.getValue(ContextKey.TRUSTSTORE_PATH));
        truststoreConfig.setPassword(properties.getValue(ContextKey.TRUSTSTORE_PASSWORD));
        this.setTruststore(truststoreConfig);
    }

    protected abstract void configureClient();

    protected abstract void configureClient(String var1);

    public void setUrl(String url) {
        this.url = url;
    }

    public void setApikey(String apikey) {
        this.apikey = apikey;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public void setSilent(String silent) {
        this.silent = silent;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setPoolSize(Integer poolSize) {
        this.poolSize = poolSize;
    }

    public void setRelay(RelayConfig relay) {
        this.relay = relay;
    }

    public void setSnapshot(SnapshotConfig snapshot) {
        this.snapshot = snapshot;
    }

    public void setTruststore(TruststoreConfig truststore) {
        this.truststore = truststore;
    }

    public static class TruststoreConfig {
        private String path;
        private String password;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class SnapshotConfig {
        private String location;
        private boolean auto;
        private boolean skipValidation;
        private boolean watcher;
        private String updateInterval;

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public boolean isAuto() {
            return this.auto;
        }

        public void setAuto(boolean auto) {
            this.auto = auto;
        }

        public boolean isSkipValidation() {
            return this.skipValidation;
        }

        public void setSkipValidation(boolean skipValidation) {
            this.skipValidation = skipValidation;
        }

        public boolean isWatcher() {
            return this.watcher;
        }

        public void setWatcher(boolean watcher) {
            this.watcher = watcher;
        }

        public String getUpdateInterval() {
            return this.updateInterval;
        }

        public void setUpdateInterval(String updateInterval) {
            this.updateInterval = updateInterval;
        }
    }

    public static class RelayConfig {
        private boolean restrict;

        public boolean isRestrict() {
            return this.restrict;
        }

        public void setRestrict(boolean restrict) {
            this.restrict = restrict;
        }
    }
}

