/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client;

import com.github.switcherapi.client.ContextBuilder;
import com.github.switcherapi.client.SnapshotCallback;
import com.github.switcherapi.client.SwitcherConfig;
import com.github.switcherapi.client.SwitcherContextValidator;
import com.github.switcherapi.client.SwitcherExecutor;
import com.github.switcherapi.client.SwitcherKey;
import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.SwitcherPropertiesImpl;
import com.github.switcherapi.client.exception.SwitcherContextException;
import com.github.switcherapi.client.exception.SwitcherException;
import com.github.switcherapi.client.exception.SwitcherKeyNotFoundException;
import com.github.switcherapi.client.exception.SwitchersValidationException;
import com.github.switcherapi.client.model.ContextKey;
import com.github.switcherapi.client.model.SwitcherRequest;
import com.github.switcherapi.client.remote.ClientWS;
import com.github.switcherapi.client.remote.ClientWSImpl;
import com.github.switcherapi.client.service.ValidatorService;
import com.github.switcherapi.client.service.WorkerName;
import com.github.switcherapi.client.service.local.ClientLocalService;
import com.github.switcherapi.client.service.local.SwitcherLocalService;
import com.github.switcherapi.client.service.remote.ClientRemoteService;
import com.github.switcherapi.client.service.remote.SwitcherRemoteService;
import com.github.switcherapi.client.utils.SnapshotEventHandler;
import com.github.switcherapi.client.utils.SnapshotWatcher;
import com.github.switcherapi.client.utils.SwitcherUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SwitcherContextBase
extends SwitcherConfig {
    protected static final Logger logger = LoggerFactory.getLogger(SwitcherContextBase.class);
    protected static SwitcherProperties switcherProperties = new SwitcherPropertiesImpl();
    protected static Set<String> switcherKeys;
    protected static Map<String, SwitcherRequest> switchers;
    protected static SwitcherExecutor switcherExecutor;
    private static ScheduledExecutorService scheduledExecutorService;
    private static ExecutorService watcherExecutorService;
    private static SnapshotWatcher watcherSnapshot;
    protected static SwitcherContextBase contextBase;

    @Override
    protected void configureClient() {
        SwitcherContextBase.setContextBase(this);
        SwitcherContextBase.configure(ContextBuilder.builder(true).context(contextBase.getClass().getName()).url(this.url).apiKey(this.apikey).domain(this.domain).environment(this.environment).component(this.component).local(this.local).checkSwitchers(this.check).restrictRelay(this.relay.isRestrict()).silentMode(this.silent).timeoutMs(this.timeout).poolConnectionSize(this.poolSize).snapshotLocation(this.snapshot.getLocation()).snapshotAutoLoad(this.snapshot.isAuto()).snapshotWatcher(this.snapshot.isWatcher()).snapshotSkipValidation(this.snapshot.isSkipValidation()).snapshotAutoUpdateInterval(this.snapshot.getUpdateInterval()).truststorePath(this.truststore.getPath()).truststorePassword(this.truststore.getPassword()));
        SwitcherContextBase.initializeClient();
    }

    @Override
    protected void configureClient(String contextFile) {
        SwitcherContextBase.setContextBase(this);
        SwitcherContextBase.loadProperties(contextFile);
        switcherProperties.setValue(ContextKey.CONTEXT_LOCATION, contextBase.getClass().getName());
        this.updateSwitcherConfig(switcherProperties);
        SwitcherContextBase.initializeClient();
    }

    protected void registerSwitcherKeys(String ... switcherKeys) {
        SwitcherContextBase.setSwitcherKeys(new HashSet<String>(Arrays.asList(switcherKeys)));
    }

    public static void loadProperties(String contextFilename) {
        try (InputStream input = SwitcherContextBase.class.getClassLoader().getResourceAsStream(String.format("%s.properties", contextFilename));){
            Properties prop = new Properties();
            prop.load(input);
            switcherProperties.loadFromProperties(prop);
        }
        catch (IOException io) {
            throw new SwitcherContextException(io.getMessage());
        }
    }

    public static void initializeClient() {
        SwitcherContextBase.validateContext();
        SwitcherContextBase.registerSwitcherKeys();
        switcherExecutor = SwitcherContextBase.buildInstance();
        SwitcherContextBase.loadSwitchers();
        SwitcherContextBase.scheduleSnapshotWatcher();
        SwitcherContextBase.scheduleSnapshotAutoUpdate(SwitcherContextBase.contextStr(ContextKey.SNAPSHOT_AUTO_UPDATE_INTERVAL));
        ContextBuilder.preConfigure(switcherProperties);
        SwitcherUtils.debug(logger, "Switcher Client initialized", new Object[0]);
    }

    private static SwitcherExecutor buildInstance() {
        ClientWS clientWS = SwitcherContextBase.initRemotePoolExecutorService();
        ValidatorService validatorService = new ValidatorService();
        ClientRemoteService clientRemote = new ClientRemoteService(clientWS, switcherProperties);
        ClientLocalService clientLocal = new ClientLocalService(validatorService);
        if (SwitcherContextBase.contextBol(ContextKey.LOCAL_MODE)) {
            return new SwitcherLocalService(clientRemote, clientLocal, switcherProperties);
        }
        return new SwitcherRemoteService(clientRemote, new SwitcherLocalService(clientRemote, clientLocal, switcherProperties));
    }

    private static void validateContext() throws SwitcherContextException {
        SwitcherProperties prop = switcherProperties;
        SwitcherContextValidator.validate(prop);
    }

    private static void registerSwitcherKeys() {
        if (Objects.nonNull(contextBase)) {
            SwitcherContextBase.registerSwitcherKey(contextBase.getClass().getFields());
        } else {
            try {
                Class<?> clazz = Class.forName(SwitcherContextBase.contextStr(ContextKey.CONTEXT_LOCATION));
                SwitcherContextBase.registerSwitcherKey(clazz.getFields());
            }
            catch (ClassNotFoundException e) {
                throw new SwitcherContextException(e.getMessage());
            }
        }
    }

    private static void registerSwitcherKey(Field[] fields) {
        switcherKeys = Optional.ofNullable(switcherKeys).orElse(new HashSet());
        for (Field field : fields) {
            if (!field.isAnnotationPresent(SwitcherKey.class)) continue;
            switcherKeys.add(field.getName());
        }
    }

    private static void loadSwitchers() throws SwitchersValidationException {
        if (SwitcherContextBase.contextBol(ContextKey.CHECK_SWITCHERS)) {
            SwitcherContextBase.checkSwitchers();
        }
        if (Objects.isNull(switchers)) {
            switchers = new HashMap<String, SwitcherRequest>();
        }
        switchers.clear();
        for (String key : switcherKeys) {
            switchers.put(key, new SwitcherRequest(key, switcherExecutor, switcherProperties));
        }
    }

    private static void scheduleSnapshotWatcher() {
        if (SwitcherContextBase.contextBol(ContextKey.SNAPSHOT_WATCHER)) {
            SwitcherContextBase.watchSnapshot();
        }
    }

    public static ScheduledFuture<?> scheduleSnapshotAutoUpdate(String intervalValue, SnapshotCallback callback) {
        if (StringUtils.isBlank((CharSequence)intervalValue) || scheduledExecutorService != null) {
            return null;
        }
        long interval = SwitcherUtils.getMillis(intervalValue);
        SnapshotCallback callbackFinal = Optional.ofNullable(callback).orElse(new SnapshotCallback(){});
        Runnable runnableSnapshotValidate = () -> {
            try {
                if (SwitcherContextBase.validateSnapshot()) {
                    callbackFinal.onSnapshotUpdate(switcherExecutor.getSnapshotVersion());
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                callbackFinal.onSnapshotUpdateError(e);
            }
        };
        SwitcherContextBase.initSnapshotExecutorService();
        return scheduledExecutorService.scheduleAtFixedRate(runnableSnapshotValidate, 0L, interval, TimeUnit.MILLISECONDS);
    }

    public static ScheduledFuture<?> scheduleSnapshotAutoUpdate(String intervalValue) {
        return SwitcherContextBase.scheduleSnapshotAutoUpdate(intervalValue, null);
    }

    private static void initSnapshotExecutorService() {
        scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setName(WorkerName.SNAPSHOT_UPDATE_WORKER.toString());
            thread.setDaemon(true);
            return thread;
        });
    }

    private static void initWatcherExecutorService() {
        watcherExecutorService = Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setName(WorkerName.SNAPSHOT_WATCH_WORKER.toString());
            thread.setDaemon(true);
            return thread;
        });
    }

    private static ClientWS initRemotePoolExecutorService() {
        int timeoutMs = Optional.ofNullable(SwitcherContextBase.contextInt(ContextKey.TIMEOUT_MS)).orElse(3000);
        int poolSize = Optional.ofNullable(SwitcherContextBase.contextInt(ContextKey.POOL_CONNECTION_SIZE)).orElse(2);
        String component = Optional.ofNullable(SwitcherContextBase.contextStr(ContextKey.COMPONENT)).orElse("switcher-client");
        ExecutorService remotePoolExecutorService = Executors.newFixedThreadPool(poolSize, r -> {
            Thread thread = new Thread(r);
            thread.setName(String.format("%s-%s", new Object[]{WorkerName.SWITCHER_REMOTE_WORKER, component}));
            thread.setDaemon(true);
            return thread;
        });
        return ClientWSImpl.build(switcherProperties, remotePoolExecutorService, timeoutMs);
    }

    public static SwitcherRequest getSwitcher(String key, boolean keepEntries) {
        SwitcherUtils.debug(logger, "key: {} - keepEntries: {}", key, keepEntries);
        if (!switchers.containsKey(key)) {
            throw new SwitcherKeyNotFoundException(key);
        }
        SwitcherRequest switcher = switchers.get(key);
        if (!keepEntries) {
            switcher.resetEntry();
        }
        return switcher;
    }

    public static SwitcherRequest getSwitcher(String key) {
        return SwitcherContextBase.getSwitcher(key, false);
    }

    public static boolean validateSnapshot() {
        if (SwitcherContextBase.contextBol(ContextKey.SNAPSHOT_SKIP_VALIDATION) || switcherExecutor.checkSnapshotVersion()) {
            return false;
        }
        switcherExecutor.updateSnapshot();
        return true;
    }

    public static void watchSnapshot() {
        SwitcherContextBase.watchSnapshot(new SnapshotEventHandler(){});
    }

    public static void watchSnapshot(SnapshotEventHandler handler) {
        if (!(switcherExecutor instanceof SwitcherLocalService)) {
            throw new SwitcherException("Cannot watch snapshot when using remote", new UnsupportedOperationException());
        }
        if (Objects.isNull(watcherSnapshot)) {
            watcherSnapshot = new SnapshotWatcher((SwitcherLocalService)switcherExecutor, handler, SwitcherContextBase.contextStr(ContextKey.SNAPSHOT_LOCATION));
        }
        SwitcherContextBase.initWatcherExecutorService();
        watcherExecutorService.submit(watcherSnapshot);
    }

    public static void stopWatchingSnapshot() {
        if (Objects.nonNull(watcherSnapshot)) {
            watcherExecutorService.shutdownNow();
            watcherSnapshot.terminate();
            watcherSnapshot = null;
        }
    }

    public static void checkSwitchers() throws SwitchersValidationException {
        switcherExecutor.checkSwitchers(switcherKeys);
    }

    public static String contextStr(ContextKey contextKey) {
        return switcherProperties.getValue(contextKey);
    }

    public static Integer contextInt(ContextKey contextKey) {
        return switcherProperties.getInt(contextKey);
    }

    public static boolean contextBol(ContextKey contextKey) {
        return switcherProperties.getBoolean(contextKey);
    }

    public static SwitcherProperties getSwitcherProperties() {
        return switcherProperties;
    }

    public static void configure(ContextBuilder builder) {
        switcherProperties = builder.build();
    }

    public static void terminateSnapshotAutoUpdateWorker() {
        if (Objects.nonNull(scheduledExecutorService)) {
            scheduledExecutorService.shutdownNow();
            scheduledExecutorService = null;
        }
    }

    private static synchronized void setContextBase(SwitcherContextBase contextBase) {
        SwitcherContextBase.contextBase = contextBase;
    }

    private static synchronized void setSwitcherKeys(Set<String> switcherKeys) {
        SwitcherContextBase.switcherKeys = switcherKeys;
    }
}

