/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client;

import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.exception.SwitcherContextException;
import com.github.switcherapi.client.model.ContextKey;
import com.github.switcherapi.client.remote.Constants;
import com.github.switcherapi.client.utils.SwitcherUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SwitcherPropertiesImpl
implements SwitcherProperties {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public SwitcherPropertiesImpl() {
        this.initDefaults();
    }

    private void initDefaults() {
        this.setValue(ContextKey.ENVIRONMENT, "default");
        this.setValue(ContextKey.REGEX_TIMEOUT, Constants.DEFAULT_REGEX_TIMEOUT);
        this.setValue(ContextKey.TIMEOUT_MS, 3000);
        this.setValue(ContextKey.POOL_CONNECTION_SIZE, 2);
        this.setValue(ContextKey.SNAPSHOT_AUTO_LOAD, false);
        this.setValue(ContextKey.SNAPSHOT_SKIP_VALIDATION, false);
        this.setValue(ContextKey.SNAPSHOT_WATCHER, false);
        this.setValue(ContextKey.LOCAL_MODE, false);
        this.setValue(ContextKey.CHECK_SWITCHERS, false);
        this.setValue(ContextKey.RESTRICT_RELAY, true);
    }

    @Override
    public void loadFromProperties(Properties prop) {
        this.setValue(ContextKey.CONTEXT_LOCATION, SwitcherUtils.resolveProperties(ContextKey.CONTEXT_LOCATION.getParam(), prop));
        this.setValue(ContextKey.URL, SwitcherUtils.resolveProperties(ContextKey.URL.getParam(), prop));
        this.setValue(ContextKey.APIKEY, SwitcherUtils.resolveProperties(ContextKey.APIKEY.getParam(), prop));
        this.setValue(ContextKey.DOMAIN, SwitcherUtils.resolveProperties(ContextKey.DOMAIN.getParam(), prop));
        this.setValue(ContextKey.COMPONENT, SwitcherUtils.resolveProperties(ContextKey.COMPONENT.getParam(), prop));
        this.setValue(ContextKey.ENVIRONMENT, this.getValueDefault(SwitcherUtils.resolveProperties(ContextKey.ENVIRONMENT.getParam(), prop), "default"));
        this.setValue(ContextKey.SNAPSHOT_LOCATION, SwitcherUtils.resolveProperties(ContextKey.SNAPSHOT_LOCATION.getParam(), prop));
        this.setValue(ContextKey.SNAPSHOT_SKIP_VALIDATION, this.getBoolDefault(SwitcherUtils.resolveProperties(ContextKey.SNAPSHOT_SKIP_VALIDATION.getParam(), prop), false));
        this.setValue(ContextKey.SNAPSHOT_AUTO_LOAD, this.getBoolDefault(SwitcherUtils.resolveProperties(ContextKey.SNAPSHOT_AUTO_LOAD.getParam(), prop), false));
        this.setValue(ContextKey.SNAPSHOT_AUTO_UPDATE_INTERVAL, SwitcherUtils.resolveProperties(ContextKey.SNAPSHOT_AUTO_UPDATE_INTERVAL.getParam(), prop));
        this.setValue(ContextKey.SNAPSHOT_WATCHER, this.getBoolDefault(SwitcherUtils.resolveProperties(ContextKey.SNAPSHOT_WATCHER.getParam(), prop), false));
        this.setValue(ContextKey.SILENT_MODE, SwitcherUtils.resolveProperties(ContextKey.SILENT_MODE.getParam(), prop));
        this.setValue(ContextKey.LOCAL_MODE, this.getBoolDefault(SwitcherUtils.resolveProperties(ContextKey.LOCAL_MODE.getParam(), prop), false));
        this.setValue(ContextKey.CHECK_SWITCHERS, this.getBoolDefault(SwitcherUtils.resolveProperties(ContextKey.CHECK_SWITCHERS.getParam(), prop), false));
        this.setValue(ContextKey.RESTRICT_RELAY, this.getBoolDefault(SwitcherUtils.resolveProperties(ContextKey.RESTRICT_RELAY.getParam(), prop), true));
        this.setValue(ContextKey.REGEX_TIMEOUT, this.getIntDefault(SwitcherUtils.resolveProperties(ContextKey.REGEX_TIMEOUT.getParam(), prop), Constants.DEFAULT_REGEX_TIMEOUT));
        this.setValue(ContextKey.TRUSTSTORE_PATH, SwitcherUtils.resolveProperties(ContextKey.TRUSTSTORE_PATH.getParam(), prop));
        this.setValue(ContextKey.TRUSTSTORE_PASSWORD, SwitcherUtils.resolveProperties(ContextKey.TRUSTSTORE_PASSWORD.getParam(), prop));
        this.setValue(ContextKey.TIMEOUT_MS, this.getIntDefault(SwitcherUtils.resolveProperties(ContextKey.TIMEOUT_MS.getParam(), prop), 3000));
        this.setValue(ContextKey.POOL_CONNECTION_SIZE, this.getIntDefault(SwitcherUtils.resolveProperties(ContextKey.POOL_CONNECTION_SIZE.getParam(), prop), 2));
    }

    @Override
    public String getValue(ContextKey contextKey) {
        return this.getValue(contextKey, String.class);
    }

    @Override
    public boolean getBoolean(ContextKey contextKey) {
        return this.getValue(contextKey, Boolean.class);
    }

    @Override
    public Integer getInt(ContextKey contextKey) {
        return this.getValue(contextKey, Integer.class);
    }

    @Override
    public void setValue(ContextKey contextKey, Object value) {
        this.properties.put(contextKey.getParam(), value);
    }

    private <T> T getValue(ContextKey contextKey, Class<T> type) {
        try {
            return type.cast(this.properties.get(contextKey.getParam()));
        }
        catch (ClassCastException e) {
            throw new SwitcherContextException(e.getMessage());
        }
    }

    private String getValueDefault(String value, String defaultValue) {
        return (String)StringUtils.defaultIfBlank((CharSequence)value, (CharSequence)defaultValue);
    }

    private Integer getIntDefault(String value, Integer defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    private Boolean getBoolDefault(String value, Boolean defaultValue) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }
}

