/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.model;

import com.github.switcherapi.client.exception.SwitcherException;
import com.github.switcherapi.client.model.Switcher;
import com.github.switcherapi.client.model.SwitcherResult;
import com.github.switcherapi.client.service.WorkerName;
import com.github.switcherapi.client.utils.SwitcherUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSwitcher {
    private static final Logger logger = LoggerFactory.getLogger(AsyncSwitcher.class);
    private final ExecutorService executorService = Executors.newCachedThreadPool(r -> {
        Thread thread = new Thread(r);
        thread.setName(WorkerName.SWITCHER_ASYNC_WORKER.toString());
        thread.setDaemon(true);
        return thread;
    });
    private final Switcher switcher;
    private final long delay;
    private long nextRun = 0L;

    public AsyncSwitcher(Switcher switcher, long delay) {
        this.switcher = switcher;
        this.delay = delay;
    }

    public synchronized void execute() {
        SwitcherUtils.debug(logger, "nextRun: {} - currentTimeMillis: {}", this.nextRun, System.currentTimeMillis());
        if (this.nextRun < System.currentTimeMillis()) {
            SwitcherUtils.debug(logger, "Running AsyncSwitcher", new Object[0]);
            this.nextRun = System.currentTimeMillis() + this.delay;
            this.executorService.submit(this::run);
        }
    }

    public void run() {
        try {
            SwitcherResult response = this.switcher.executeCriteria();
            this.switcher.updateHistoryExecution(response);
        }
        catch (SwitcherException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

