/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.model;

import com.github.switcherapi.client.model.StrategyValidator;

public class Entry {
    private final String strategy;
    private final String input;

    private Entry(String strategy, String input) {
        this.strategy = strategy;
        this.input = input;
    }

    private Entry(StrategyValidator strategy, String input) {
        this(strategy.toString(), input);
    }

    public static Entry build(StrategyValidator strategy, String input) {
        return new Entry(strategy, input);
    }

    public static Entry build(String strategy, String input) {
        return new Entry(strategy, input);
    }

    public String getStrategy() {
        return this.strategy;
    }

    public String getInput() {
        return this.input;
    }

    public String toString() {
        return String.format("Entry [strategy = %s, input = %s]", this.strategy, this.input);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.input == null ? 0 : this.input.hashCode());
        result = 31 * result + (this.strategy == null ? 0 : this.strategy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Entry) {
            Entry entry = (Entry)obj;
            if (!this.strategy.equals(entry.getStrategy())) {
                return false;
            }
            return this.input.equals(entry.getInput());
        }
        return true;
    }
}

