/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.model.criteria;

import com.github.switcherapi.client.model.criteria.Relay;
import com.github.switcherapi.client.model.criteria.Strategy;
import com.github.switcherapi.client.model.criteria.SwitcherElement;
import java.util.Arrays;
import java.util.Objects;

public class Config
extends SwitcherElement {
    private final String key;
    private final Strategy[] strategies;
    private final String[] components;
    private final Relay relay;

    public Config(String key, String description, boolean activated, Strategy[] strategies, String[] components, Relay relay) {
        super(description, activated);
        this.key = key;
        this.strategies = strategies;
        this.components = components;
        this.relay = relay;
    }

    public boolean hasRelayEnabled() {
        return Objects.nonNull(this.relay) && this.relay.isActivated();
    }

    public String getKey() {
        return this.key;
    }

    public Relay getRelay() {
        return this.relay;
    }

    public Strategy[] getStrategies() {
        return this.strategies;
    }

    public String[] getComponents() {
        return this.components;
    }

    public String toString() {
        return String.format("Config [key = %s, description = %s, activated = %s, strategies = %s, components = %s]", this.key, this.description, this.activated, Arrays.toString(this.strategies), Arrays.toString(this.components));
    }
}

