/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.service.remote;

import com.github.switcherapi.client.SwitcherProperties;
import com.github.switcherapi.client.exception.SwitcherException;
import com.github.switcherapi.client.exception.SwitcherInvalidDateTimeArgumentException;
import com.github.switcherapi.client.exception.SwitcherRemoteException;
import com.github.switcherapi.client.model.ContextKey;
import com.github.switcherapi.client.model.criteria.Snapshot;
import com.github.switcherapi.client.remote.ClientWS;
import com.github.switcherapi.client.remote.dto.AuthResponse;
import com.github.switcherapi.client.remote.dto.CriteriaRequest;
import com.github.switcherapi.client.remote.dto.CriteriaResponse;
import com.github.switcherapi.client.remote.dto.SnapshotVersionResponse;
import com.github.switcherapi.client.remote.dto.SwitchersCheck;
import com.github.switcherapi.client.service.remote.ClientRemote;
import com.github.switcherapi.client.utils.SwitcherUtils;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ClientRemoteService
implements ClientRemote {
    private final SwitcherProperties switcherProperties;
    private final ClientWS clientWs;
    private AuthResponse authResponse;

    public ClientRemoteService(ClientWS clientWs, SwitcherProperties switcherProperties) {
        this.clientWs = clientWs;
        this.switcherProperties = switcherProperties;
    }

    @Override
    public CriteriaResponse executeCriteria(CriteriaRequest criteriaRequest) {
        TokenStatus tokenStatus = this.isTokenValid();
        try {
            this.auth(tokenStatus);
            return this.clientWs.executeCriteria(criteriaRequest, Optional.of(this.authResponse).orElseGet(AuthResponse::new).getToken());
        }
        catch (SwitcherRemoteException e) {
            if (tokenStatus != TokenStatus.SILENT) {
                this.setSilentModeExpiration();
            }
            throw e;
        }
    }

    @Override
    public Snapshot resolveSnapshot() throws SwitcherException {
        this.auth(this.isTokenValid());
        return this.clientWs.resolveSnapshot(Optional.of(this.authResponse).orElseGet(AuthResponse::new).getToken());
    }

    @Override
    public boolean checkSnapshotVersion(long version) {
        this.auth(this.isTokenValid());
        SnapshotVersionResponse snapshotVersionResponse = this.clientWs.checkSnapshotVersion(version, Optional.of(this.authResponse).orElseGet(AuthResponse::new).getToken());
        return snapshotVersionResponse.isUpdated();
    }

    @Override
    public SwitchersCheck checkSwitchers(Set<String> switchers) {
        TokenStatus tokenStatus = this.isTokenValid();
        try {
            this.auth(tokenStatus);
            return this.clientWs.checkSwitchers(switchers, Optional.of(this.authResponse).orElseGet(AuthResponse::new).getToken());
        }
        catch (SwitcherRemoteException e) {
            if (tokenStatus != TokenStatus.SILENT) {
                this.setSilentModeExpiration();
            }
            throw e;
        }
    }

    private void auth(TokenStatus tokenStatus) {
        if (tokenStatus == TokenStatus.INVALID) {
            this.authResponse = this.clientWs.auth().orElseGet(AuthResponse::new);
        }
        if (tokenStatus == TokenStatus.SILENT) {
            throw new SwitcherRemoteException(this.switcherProperties.getValue(ContextKey.URL));
        }
    }

    private TokenStatus isTokenValid() throws SwitcherRemoteException, SwitcherInvalidDateTimeArgumentException {
        Optional<AuthResponse> optAuthResponse = Optional.ofNullable(this.authResponse);
        if (optAuthResponse.isEmpty()) {
            return TokenStatus.INVALID;
        }
        if (optAuthResponse.get().getToken().equals(ContextKey.SILENT_MODE.getParam()) && !optAuthResponse.get().isExpired()) {
            return TokenStatus.SILENT;
        }
        return optAuthResponse.orElseGet(AuthResponse::new).isExpired() ? TokenStatus.INVALID : TokenStatus.VALID;
    }

    private void setSilentModeExpiration() throws SwitcherInvalidDateTimeArgumentException {
        if (StringUtils.isNotBlank((CharSequence)this.switcherProperties.getValue(ContextKey.SILENT_MODE))) {
            String addValue = this.switcherProperties.getValue(ContextKey.SILENT_MODE);
            AuthResponse response = new AuthResponse();
            response.setToken(ContextKey.SILENT_MODE.getParam());
            response.setExp(SwitcherUtils.addTimeDuration(addValue, new Date()).getTime() / 1000L);
            this.authResponse = response;
        }
    }

    private static enum TokenStatus {
        VALID,
        INVALID,
        SILENT;

    }
}

