/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.service.remote;

import com.github.switcherapi.client.SwitcherExecutor;
import com.github.switcherapi.client.SwitcherExecutorImpl;
import com.github.switcherapi.client.exception.SwitcherRemoteException;
import com.github.switcherapi.client.exception.SwitchersValidationException;
import com.github.switcherapi.client.model.ContextKey;
import com.github.switcherapi.client.model.SwitcherRequest;
import com.github.switcherapi.client.model.SwitcherResult;
import com.github.switcherapi.client.remote.dto.CriteriaResponse;
import com.github.switcherapi.client.remote.dto.SwitchersCheck;
import com.github.switcherapi.client.service.SwitcherFactory;
import com.github.switcherapi.client.service.remote.ClientRemote;
import com.github.switcherapi.client.utils.Mapper;
import com.github.switcherapi.client.utils.SwitcherUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitcherRemoteService
extends SwitcherExecutorImpl {
    private static final Logger logger = LoggerFactory.getLogger(SwitcherRemoteService.class);
    private final SwitcherExecutor switcherLocal;
    private final ClientRemote clientRemote;

    public SwitcherRemoteService(ClientRemote clientRemote, SwitcherExecutor switcherExecutor) {
        super(switcherExecutor.getSwitcherProperties());
        this.clientRemote = clientRemote;
        this.switcherLocal = switcherExecutor;
    }

    @Override
    public SwitcherResult executeCriteria(SwitcherRequest switcher) {
        SwitcherUtils.debug(logger, "[Remote] request: {}", switcher);
        try {
            CriteriaResponse response = this.clientRemote.executeCriteria(Mapper.mapFrom(switcher));
            SwitcherUtils.debug(logger, "[Remote] response: {}", response);
            return Mapper.mapFrom(response);
        }
        catch (SwitcherRemoteException e) {
            logger.error("Failed to execute criteria - Cause: {}", (Object)e.getMessage(), (Object)e.getCause());
            return this.tryExecuteLocalCriteria(switcher, e);
        }
    }

    private SwitcherResult tryExecuteLocalCriteria(SwitcherRequest switcher, SwitcherRemoteException e) {
        if (StringUtils.isNotBlank((CharSequence)this.switcherProperties.getValue(ContextKey.SILENT_MODE))) {
            SwitcherResult response = this.switcherLocal.executeCriteria(switcher);
            SwitcherUtils.debug(logger, "[Silent] response: {}", response);
            return response;
        }
        if (StringUtils.isNotBlank((CharSequence)switcher.getDefaultResult())) {
            SwitcherResult response = SwitcherFactory.buildFromDefault(switcher);
            SwitcherUtils.debug(logger, "[Default] response: {}", response);
            return response;
        }
        throw e;
    }

    @Override
    public boolean checkSnapshotVersion() {
        if (StringUtils.isNotBlank((CharSequence)this.switcherProperties.getValue(ContextKey.SNAPSHOT_LOCATION)) && Objects.nonNull(this.switcherLocal.getDomain())) {
            return super.checkSnapshotVersion(this.clientRemote, this.switcherLocal.getDomain());
        }
        super.initializeSnapshotFromAPI(this.clientRemote);
        return Boolean.TRUE;
    }

    @Override
    public void updateSnapshot() {
        this.switcherLocal.setDomain(super.initializeSnapshotFromAPI(this.clientRemote));
    }

    @Override
    public void checkSwitchers(Set<String> switchers) {
        SwitcherUtils.debug(logger, "switchers: {}", switchers);
        SwitchersCheck response = this.clientRemote.checkSwitchers(switchers);
        if (response.getNotFound() != null && response.getNotFound().length > 0) {
            throw new SwitchersValidationException(Arrays.toString(response.getNotFound()));
        }
    }

    @Override
    public long getSnapshotVersion() {
        return this.switcherLocal.getSnapshotVersion();
    }
}

