/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.service.validators;

import com.github.switcherapi.client.exception.SwitcherInvalidNumericFormat;
import com.github.switcherapi.client.exception.SwitcherInvalidOperationException;
import com.github.switcherapi.client.model.Entry;
import com.github.switcherapi.client.model.StrategyValidator;
import com.github.switcherapi.client.model.criteria.Strategy;
import com.github.switcherapi.client.service.validators.Validator;
import java.util.Arrays;
import org.apache.commons.lang3.math.NumberUtils;

public class NumericValidator
extends Validator {
    @Override
    public StrategyValidator getType() {
        return StrategyValidator.NUMERIC;
    }

    @Override
    public boolean process(Strategy strategy, Entry switcherInput) {
        if (!NumberUtils.isCreatable((String)switcherInput.getInput())) {
            throw new SwitcherInvalidNumericFormat(switcherInput.getInput());
        }
        switch (strategy.getEntryOperation()) {
            case EXIST: {
                return Arrays.stream(strategy.getValues()).anyMatch(val -> val.equals(switcherInput.getInput()));
            }
            case NOT_EXIST: {
                return Arrays.stream(strategy.getValues()).noneMatch(val -> val.equals(switcherInput.getInput()));
            }
            case EQUAL: {
                return strategy.getValues().length == 1 && strategy.getValues()[0].equals(switcherInput.getInput());
            }
            case NOT_EQUAL: {
                return strategy.getValues().length == 1 && !strategy.getValues()[0].equals(switcherInput.getInput());
            }
            case LOWER: {
                double numericValue;
                if (strategy.getValues().length != 1) break;
                double numericInput = NumberUtils.createNumber((String)switcherInput.getInput()).doubleValue();
                return numericInput < (numericValue = NumberUtils.createNumber((String)strategy.getValues()[0]).doubleValue());
            }
            case GREATER: {
                double numericValue;
                if (strategy.getValues().length != 1) break;
                double numericInput = NumberUtils.createNumber((String)switcherInput.getInput()).doubleValue();
                return numericInput > (numericValue = NumberUtils.createNumber((String)strategy.getValues()[0]).doubleValue());
            }
            case BETWEEN: {
                if (strategy.getValues().length != 2) break;
                double numericInput = NumberUtils.createNumber((String)switcherInput.getInput()).doubleValue();
                double numericFirstValue = NumberUtils.createNumber((String)strategy.getValues()[0]).doubleValue();
                double numericSecondValue = NumberUtils.createNumber((String)strategy.getValues()[1]).doubleValue();
                return numericInput >= numericFirstValue && numericFirstValue <= numericSecondValue;
            }
            default: {
                throw new SwitcherInvalidOperationException(strategy.getOperation(), strategy.getStrategy());
            }
        }
        throw new SwitcherInvalidOperationException(strategy.getOperation(), strategy.getStrategy());
    }
}

