/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.service.validators;

import com.github.switcherapi.client.exception.SwitcherInvalidOperationException;
import com.github.switcherapi.client.exception.SwitcherInvalidOperationInputException;
import com.github.switcherapi.client.exception.SwitcherInvalidTimeFormat;
import com.github.switcherapi.client.model.Entry;
import com.github.switcherapi.client.model.EntryOperation;
import com.github.switcherapi.client.model.StrategyValidator;
import com.github.switcherapi.client.model.criteria.Strategy;
import com.github.switcherapi.client.service.validators.DateTimeValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class TimeValidator
extends DateTimeValidator {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    @Override
    public StrategyValidator getType() {
        return StrategyValidator.TIME;
    }

    @Override
    public boolean process(Strategy strategy, Entry switcherInput) throws SwitcherInvalidOperationException, SwitcherInvalidTimeFormat, SwitcherInvalidOperationInputException {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            String today = format.format(new Date());
            return this.selectTimeOperationCase(strategy, switcherInput, today);
        }
        catch (ParseException e) {
            throw new SwitcherInvalidTimeFormat(strategy.getStrategy(), e);
        }
    }

    private boolean selectTimeOperationCase(Strategy strategy, Entry switcherInput, String today) throws ParseException {
        switch (strategy.getEntryOperation()) {
            case LOWER: {
                Date stgDate = DateUtils.parseDate((String)this.getFullTime(today, strategy.getValues()[0]), (String[])new String[]{DATE_FORMAT});
                Date inputDate = DateUtils.parseDate((String)this.getFullTime(today, switcherInput.getInput()), (String[])new String[]{DATE_FORMAT});
                return inputDate.before(stgDate);
            }
            case GREATER: {
                Date stgDate = DateUtils.parseDate((String)this.getFullTime(today, strategy.getValues()[0]), (String[])new String[]{DATE_FORMAT});
                Date inputDate = DateUtils.parseDate((String)this.getFullTime(today, switcherInput.getInput()), (String[])new String[]{DATE_FORMAT});
                return inputDate.after(stgDate);
            }
            case BETWEEN: {
                if (strategy.getValues().length == 2) {
                    Date stgDate = DateUtils.parseDate((String)this.getFullTime(today, strategy.getValues()[0]), (String[])new String[]{DATE_FORMAT});
                    Date stgDate2 = DateUtils.parseDate((String)this.getFullTime(today, strategy.getValues()[1]), (String[])new String[]{DATE_FORMAT});
                    Date inputDate = DateUtils.parseDate((String)this.getFullTime(today, switcherInput.getInput()), (String[])new String[]{DATE_FORMAT});
                    return inputDate.after(stgDate) && inputDate.before(stgDate2);
                }
                throw new SwitcherInvalidOperationInputException(EntryOperation.BETWEEN.name());
            }
        }
        throw new SwitcherInvalidOperationException(strategy.getOperation(), strategy.getStrategy());
    }
}

