/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.test;

import com.github.switcherapi.client.model.SwitcherResult;
import com.github.switcherapi.client.test.SwitcherBypass;
import com.github.switcherapi.client.test.SwitcherTest;
import com.github.switcherapi.client.test.SwitcherTestTemplate;
import com.github.switcherapi.client.test.SwitcherTestValue;
import com.github.switcherapi.client.test.SwitcherTestWhen;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

class SwitcherTestExtension
implements TestTemplateInvocationContextProvider,
AfterTestExecutionCallback,
BeforeTestExecutionCallback {
    private static final String STORE_KEYS = "mock.keys";
    private static final String STORE_KEY = "mock.key";
    private boolean abTest;

    SwitcherTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        return context.getRequiredTestMethod().isAnnotationPresent(SwitcherTest.class);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        SwitcherTest switcherTest = context.getRequiredTestMethod().getAnnotation(SwitcherTest.class);
        if (switcherTest.abTest()) {
            return Stream.of(new SwitcherTestTemplate(switcherTest, true), new SwitcherTestTemplate(switcherTest));
        }
        SwitcherTestTemplate template = new SwitcherTestTemplate(switcherTest);
        return Stream.of(template);
    }

    public void beforeTestExecution(ExtensionContext context) {
        SwitcherTest switcherTest = context.getRequiredTestMethod().getAnnotation(SwitcherTest.class);
        if (switcherTest.abTest()) {
            boolean bl = this.abTest = !this.abTest;
        }
        if (ArrayUtils.isNotEmpty((Object[])switcherTest.switchers())) {
            this.mockMultipleSwitchers(context, switcherTest, this.abTest);
        } else {
            this.mockSingleSwitcher(context, switcherTest, this.abTest);
        }
    }

    public void afterTestExecution(ExtensionContext context) {
        ExtensionContext.Store store = this.getStore(context);
        Object[] keys = (String[])store.remove((Object)STORE_KEYS, String[].class);
        if (ArrayUtils.isNotEmpty((Object[])keys)) {
            for (Object keyStored : keys) {
                SwitcherBypass.forget((String)keyStored);
            }
        } else {
            String switcherKey = (String)store.remove((Object)STORE_KEY, String.class);
            SwitcherBypass.forget(switcherKey);
        }
    }

    private void mockMultipleSwitchers(ExtensionContext context, SwitcherTest switcherTest, boolean inverted) {
        String[] keys = (String[])Arrays.stream(switcherTest.switchers()).map(SwitcherTestValue::key).toArray(String[]::new);
        for (SwitcherTestValue value : switcherTest.switchers()) {
            SwitcherResult switcherResult = SwitcherBypass.assume(value.key(), inverted != value.result(), value.metadata());
            this.applySwitcherTestWhen(switcherResult, value.when());
        }
        this.getStore(context).put((Object)STORE_KEYS, (Object)keys);
    }

    private void mockSingleSwitcher(ExtensionContext context, SwitcherTest switcherTest, boolean inverted) {
        SwitcherResult switcherResult = SwitcherBypass.assume(switcherTest.key(), inverted != switcherTest.result(), switcherTest.metadata());
        this.applySwitcherTestWhen(switcherResult, switcherTest.when());
        this.getStore(context).put((Object)STORE_KEY, (Object)switcherTest.key());
    }

    private void applySwitcherTestWhen(SwitcherResult switcherResult, SwitcherTestWhen[] whens) {
        for (SwitcherTestWhen when : whens) {
            switcherResult.when(when.strategy(), Arrays.asList(when.input()));
        }
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create((Object[])new Object[]{this.getClass(), context}));
    }
}

