/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.test;

import com.github.switcherapi.client.test.SwitcherTest;
import com.github.switcherapi.client.test.SwitcherTestWhen;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;

class SwitcherTestTemplate
implements TestTemplateInvocationContext {
    private static final String DISPLAY_NAME_TEMPLATE = "With %s as %s";
    private static final String WHEN_TEMPLATE = "when %s = %s";
    private final SwitcherTest switcherTest;
    private boolean inverted;

    SwitcherTestTemplate(SwitcherTest switcherTest, boolean inverted) {
        this.switcherTest = switcherTest;
        this.inverted = inverted;
    }

    SwitcherTestTemplate(SwitcherTest switcherTest) {
        this.switcherTest = switcherTest;
    }

    public String getDisplayName(int invocationIndex) {
        Object[] switcherTestValues = this.switcherTest.switchers();
        if (ArrayUtils.isNotEmpty((Object[])switcherTestValues)) {
            return String.join((CharSequence)", ", Arrays.toString(Arrays.stream(switcherTestValues).map(value -> this.concatWhens(String.format(DISPLAY_NAME_TEMPLATE, value.key(), this.inverted != value.result()), value.when())).toArray()));
        }
        String displayName = String.format(DISPLAY_NAME_TEMPLATE, this.switcherTest.key(), this.inverted != this.switcherTest.result());
        return this.concatWhens(displayName, this.switcherTest.when());
    }

    private String concatWhens(String displayName, SwitcherTestWhen[] switcherTestWhens) {
        if (ArrayUtils.isNotEmpty((Object[])switcherTestWhens)) {
            return displayName + " - " + Arrays.toString(Arrays.stream(switcherTestWhens).map(when -> String.format(WHEN_TEMPLATE, new Object[]{when.strategy(), Arrays.toString(when.input())})).toArray());
        }
        return displayName;
    }
}

