/*
 * Decompiled with CFR 0.152.
 */
package com.github.switcherapi.client.utils;

import com.github.switcherapi.client.model.criteria.Config;
import com.github.switcherapi.client.model.criteria.Domain;
import com.github.switcherapi.client.model.criteria.Group;
import com.github.switcherapi.client.model.criteria.Strategy;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;

class SnapshotSerializer
implements JsonSerializer<Domain> {
    SnapshotSerializer() {
    }

    public JsonElement serialize(Domain domain, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(Field.NAME.value(), context.serialize((Object)domain.getName()));
        jsonObject.add(Field.DESCRIPTION.value(), context.serialize((Object)domain.getDescription()));
        jsonObject.add(Field.ACTIVATED.value(), context.serialize((Object)domain.isActivated()));
        jsonObject.add(Field.VERSION.value(), context.serialize((Object)domain.getVersion()));
        jsonObject.add(Field.GROUP.value(), (JsonElement)this.serializeGroup(domain, context));
        return jsonObject;
    }

    private JsonArray serializeGroup(Domain domain, JsonSerializationContext context) {
        JsonArray groupArray = new JsonArray();
        if (Objects.nonNull(domain.getGroup())) {
            for (Group group : domain.getGroup()) {
                JsonObject groupObject = new JsonObject();
                groupObject.add(Field.NAME.value(), context.serialize((Object)group.getName()));
                groupObject.add(Field.DESCRIPTION.value(), context.serialize((Object)group.getDescription()));
                groupObject.add(Field.ACTIVATED.value(), context.serialize((Object)group.isActivated()));
                groupObject.add(Field.CONFIG.value(), (JsonElement)this.serializeConfig(group, context));
                groupArray.add((JsonElement)groupObject);
            }
        }
        return groupArray;
    }

    private JsonArray serializeConfig(Group group, JsonSerializationContext context) {
        JsonArray configArray = new JsonArray();
        if (Objects.nonNull(group.getConfig())) {
            for (Config config : group.getConfig()) {
                JsonObject configObject = new JsonObject();
                configObject.add(Field.KEY.value(), context.serialize((Object)config.getKey()));
                configObject.add(Field.DESCRIPTION.value(), context.serialize((Object)config.getDescription()));
                configObject.add(Field.ACTIVATED.value(), context.serialize((Object)config.isActivated()));
                configObject.add(Field.STRATEGIES.value(), (JsonElement)this.serializeStrategies(config, context));
                configObject.add(Field.RELAY.value(), context.serialize((Object)config.getRelay()));
                configObject.add(Field.COMPONENTS.value(), context.serialize((Object)config.getComponents()));
                configArray.add((JsonElement)configObject);
            }
        }
        return configArray;
    }

    private JsonArray serializeStrategies(Config config, JsonSerializationContext context) {
        JsonArray strategiesArray = new JsonArray();
        if (Objects.nonNull(config.getStrategies())) {
            for (Strategy strategy : config.getStrategies()) {
                JsonObject strategyObject = new JsonObject();
                strategyObject.add(Field.STRATEGY.value(), context.serialize((Object)strategy.getStrategy()));
                strategyObject.add(Field.OPERATION.value(), context.serialize((Object)strategy.getOperation()));
                strategyObject.add(Field.DESCRIPTION.value(), context.serialize((Object)strategy.getDescription()));
                strategyObject.add(Field.ACTIVATED.value(), context.serialize((Object)strategy.isActivated()));
                strategyObject.add(Field.VALUES.value(), context.serialize((Object)strategy.getValues()));
                strategiesArray.add((JsonElement)strategyObject);
            }
        }
        return strategiesArray;
    }

    private static enum Field {
        NAME("name"),
        DESCRIPTION("description"),
        ACTIVATED("activated"),
        VERSION("version"),
        GROUP("group"),
        CONFIG("config"),
        KEY("key"),
        COMPONENTS("components"),
        STRATEGIES("strategies"),
        RELAY("relay"),
        STRATEGY("strategy"),
        OPERATION("operation"),
        VALUES("values");

        private final String value;

        private Field(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

