/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestJavadocTest {
    @Test
    public void testFindJavadocDifferencesNone() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().build(), (Javadoc)EditableJavadoc.builder().build()));
    }

    @Test
    public void testFindJavadocDifferencesBothNull() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findJavadocDifferences(null, null));
    }

    @Test
    public void testFindJavadocDifferencesDoc1NullDoc2Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the Javadocs is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findJavadocDifferences(null, (Javadoc)EditableJavadoc.builder().build()));
    }

    @Test
    public void testFindJavadocDifferencesDoc2NullDoc1Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the Javadocs is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().build(), null));
    }

    @Test
    public void testFindJavadocDifferencesEditable() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)UneditableJavadoc.builder().build(), (Javadoc)EditableJavadoc.builder().build()));
    }

    @Test
    public void testFindJavadocDifferencesCondensed() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Condensed is different!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().condensed().build(), (Javadoc)EditableJavadoc.builder().condensed(false).build()));
    }

    @Test
    public void testFindJavadocDifferencesContent() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Content differs on #1!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().content("something").build(), (Javadoc)EditableJavadoc.builder().content("yep").build()));
    }

    @Test
    public void testFindJavadocDifferencesContentLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Content length is different!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().content("something").build(), (Javadoc)EditableJavadoc.builder().content("something").content("yep").build()));
    }

    @Test
    public void testFindJavadocDifferencesContentLengthDoc1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Content length is different!", "Content differs on #2!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().content("something").content("yep").build(), (Javadoc)EditableJavadoc.builder().content("something").build()));
    }

    @Test
    public void testFindJavadocDifferencesAuthor() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Author is different!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().author("Logan Ferree (Tadukoo)").build(), (Javadoc)EditableJavadoc.builder().author("Logan Ferree").build()));
    }

    @Test
    public void testFindJavadocDifferencesVersion() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Version is different!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().version("Alpha v.0.1").build(), (Javadoc)EditableJavadoc.builder().version("Pre-Alpha").build()));
    }

    @Test
    public void testFindJavadocDifferencesSince() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Since is different!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().since("Pre-Alpha").build(), (Javadoc)EditableJavadoc.builder().since("Alpha v.0.1").build()));
    }

    @Test
    public void testFindJavadocDifferencesParamsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Params length is different!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().param("String", "something").build(), (Javadoc)EditableJavadoc.builder().param("String", "something").param("int", "version").build()));
    }

    @Test
    public void testFindJavadocDifferencesParamsLengthDoc1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Params length is different!", "Params differs on #2!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().param("String", "something").param("int", "version").build(), (Javadoc)EditableJavadoc.builder().param("String", "something").build()));
    }

    @Test
    public void testFindJavadocDifferencesReturnVal() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Return is different!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().returnVal("null").build(), (Javadoc)EditableJavadoc.builder().returnVal("true if true").build()));
    }

    @Test
    public void testFindJavadocDifferencesThrowsLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Throws length is different!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").build(), (Javadoc)EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").throwsInfo("IllegalArgumentException", "why not?").build()));
    }

    @Test
    public void testFindJavadocDifferencesThrowsLengthDoc1Longer() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Throws length is different!", "Throws differs on #2!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").throwsInfo("IllegalArgumentException", "why not?").build(), (Javadoc)EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").build()));
    }

    @Test
    public void testFindJavadocDifferencesAll() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!", "Condensed is different!", "Content length is different!", "Content differs on #1!", "Author is different!", "Version is different!", "Since is different!", "Params length is different!", "Params differs on #1!", "Return is different!", "Throws length is different!", "Throws differs on #1!"}), (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)UneditableJavadoc.builder().condensed().content("something").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Pre-Alpha").param("String", "somethingElse").returnVal("null").throwsInfo("IllegalStateException", "something").build(), (Javadoc)EditableJavadoc.builder().condensed(false).content("yep").content("nope").author("Logan Ferree").version("Pre-Alpha").since("Alpha v.0.1").param("String", "something").param("int", "version").returnVal("true if true").throwsInfo("IllegalStateException", "somethingElse").throwsInfo("IllegalArgumentException", "why not?").build()));
    }

    @Test
    public void testAssertJavadocEqualsNone() {
        JavaCodeTypeTest.assertJavadocEquals((Javadoc)EditableJavadoc.builder().build(), (Javadoc)EditableJavadoc.builder().build());
    }

    @Test
    public void testAssertJavadocEqualsBothNull() {
        JavaCodeTypeTest.assertJavadocEquals(null, null);
    }

    @Test
    public void testAssertJavadocEqualsDoc1NullDoc2Not() {
        Javadoc doc2 = EditableJavadoc.builder().build();
        try {
            JavaCodeTypeTest.assertJavadocEquals(null, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the Javadocs is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError(null, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsDoc2NullDoc1Not() {
        Javadoc doc1 = EditableJavadoc.builder().build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, null);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the Javadocs is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, null)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsEditable() {
        Javadoc doc1 = UneditableJavadoc.builder().build();
        Javadoc doc2 = EditableJavadoc.builder().build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsCondensed() {
        Javadoc doc1 = EditableJavadoc.builder().condensed().build();
        Javadoc doc2 = EditableJavadoc.builder().condensed(false).build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Condensed is different!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsContent() {
        Javadoc doc1 = EditableJavadoc.builder().content("something").build();
        Javadoc doc2 = EditableJavadoc.builder().content("yep").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Content differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsContentLength() {
        Javadoc doc1 = EditableJavadoc.builder().content("something").build();
        Javadoc doc2 = EditableJavadoc.builder().content("something").content("yep").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Content length is different!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsContentLengthDoc1Longer() {
        Javadoc doc1 = EditableJavadoc.builder().content("something").content("yep").build();
        Javadoc doc2 = EditableJavadoc.builder().content("something").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Content length is different!\nContent differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsAuthor() {
        Javadoc doc1 = EditableJavadoc.builder().author("Logan Ferree (Tadukoo)").build();
        Javadoc doc2 = EditableJavadoc.builder().author("Logan Ferree").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Author is different!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsVersion() {
        Javadoc doc1 = EditableJavadoc.builder().version("Alpha v.0.1").build();
        Javadoc doc2 = EditableJavadoc.builder().version("Pre-Alpha").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Version is different!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsSince() {
        Javadoc doc1 = EditableJavadoc.builder().since("Pre-Alpha").build();
        Javadoc doc2 = EditableJavadoc.builder().since("Alpha v.0.1").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Since is different!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsParamsLength() {
        Javadoc doc1 = EditableJavadoc.builder().param("String", "something").build();
        Javadoc doc2 = EditableJavadoc.builder().param("String", "something").param("int", "version").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Params length is different!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsParamsLengthDoc1Longer() {
        Javadoc doc1 = EditableJavadoc.builder().param("String", "something").param("int", "version").build();
        Javadoc doc2 = EditableJavadoc.builder().param("String", "something").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Params length is different!\nParams differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsReturnVal() {
        Javadoc doc1 = EditableJavadoc.builder().returnVal("null").build();
        Javadoc doc2 = EditableJavadoc.builder().returnVal("true if true").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Return is different!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsThrowsLength() {
        Javadoc doc1 = EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").build();
        Javadoc doc2 = EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").throwsInfo("IllegalArgumentException", "why not?").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Throws length is different!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsThrowsLengthDoc1Longer() {
        Javadoc doc1 = EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").throwsInfo("IllegalArgumentException", "why not?").build();
        Javadoc doc2 = EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Throws length is different!\nThrows differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertJavadocEqualsAll() {
        Javadoc doc1 = UneditableJavadoc.builder().condensed().content("something").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Pre-Alpha").param("String", "somethingElse").returnVal("null").throwsInfo("IllegalStateException", "something").build();
        Javadoc doc2 = EditableJavadoc.builder().condensed(false).content("yep").content("nope").author("Logan Ferree").version("Pre-Alpha").since("Alpha v.0.1").param("String", "something").param("int", "version").returnVal("true if true").throwsInfo("IllegalStateException", "somethingElse").throwsInfo("IllegalArgumentException", "why not?").build();
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)doc1, (Javadoc)doc2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!\nCondensed is different!\nContent length is different!\nContent differs on #1!\nAuthor is different!\nVersion is different!\nSince is different!\nParams length is different!\nParams differs on #1!\nReturn is different!\nThrows length is different!\nThrows differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)doc1, (Object)doc2)), (Object)e.getMessage());
        }
    }
}

