/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.UneditableJavaMultiLineComment;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestMultiLineCommentTest {
    @Test
    public void testFindMultiLineCommentDifferencesNone() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findMultiLineCommentDifferences((JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").build(), (JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").build()));
    }

    @Test
    public void testFindMultiLineCommentDifferencesBothNull() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findMultiLineCommentDifferences(null, null));
    }

    @Test
    public void testFindMultiLineCommentDifferencesComment1NullComment2Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the multi-line comments is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findMultiLineCommentDifferences(null, (JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").build()));
    }

    @Test
    public void testFindMultiLineCommentDifferencesComment2NullComment1Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the multi-line comments is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findMultiLineCommentDifferences((JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").build(), null));
    }

    @Test
    public void testFindMultiLineCommentDifferencesEditable() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!"}), (Object)JavaCodeTypeTest.findMultiLineCommentDifferences((JavaMultiLineComment)UneditableJavaMultiLineComment.builder().content("Something useful").build(), (JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").build()));
    }

    @Test
    public void testFindMultiLineCommentDifferencesContent() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Content differs on #1!"}), (Object)JavaCodeTypeTest.findMultiLineCommentDifferences((JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").build(), (JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something else useful").build()));
    }

    @Test
    public void testFindMultiLineCommentDifferencesContentLength() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Content length is different!", "Content differs on #2!"}), (Object)JavaCodeTypeTest.findMultiLineCommentDifferences((JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").content("Another line").build(), (JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").build()));
    }

    @Test
    public void testFindMultiLineCommentDifferencesAll() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!", "Content length is different!", "Content differs on #1!"}), (Object)JavaCodeTypeTest.findMultiLineCommentDifferences((JavaMultiLineComment)UneditableJavaMultiLineComment.builder().content("Something useful").build(), (JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something else useful").content("Another line").build()));
    }

    @Test
    public void testAssertMultiLineCommentEqualsNone() {
        JavaCodeTypeTest.assertMultiLineCommentEquals((JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").build(), (JavaMultiLineComment)EditableJavaMultiLineComment.builder().content("Something useful").build());
    }

    @Test
    public void testAssertMultiLineCommentEqualsBothNull() {
        JavaCodeTypeTest.assertMultiLineCommentEquals(null, null);
    }

    @Test
    public void testAssertMultiLineCommentEqualsComment1NullComment2Not() {
        JavaMultiLineComment comment2 = EditableJavaMultiLineComment.builder().content("Something useful").build();
        try {
            JavaCodeTypeTest.assertMultiLineCommentEquals(null, (JavaMultiLineComment)comment2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the multi-line comments is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError(null, (Object)comment2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMultiLineCommentEqualsComment2NullComment1Not() {
        JavaMultiLineComment comment1 = EditableJavaMultiLineComment.builder().content("Something useful").build();
        try {
            JavaCodeTypeTest.assertMultiLineCommentEquals((JavaMultiLineComment)comment1, null);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the multi-line comments is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)comment1, null)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMultiLineCommentEqualsEditable() {
        JavaMultiLineComment comment1 = UneditableJavaMultiLineComment.builder().content("Something useful").build();
        JavaMultiLineComment comment2 = EditableJavaMultiLineComment.builder().content("Something useful").build();
        try {
            JavaCodeTypeTest.assertMultiLineCommentEquals((JavaMultiLineComment)comment1, (JavaMultiLineComment)comment2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!", (String)AssertionFailedErrors.buildAssertError((Object)comment1, (Object)comment2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMultiLineCommentEqualsContent() {
        JavaMultiLineComment comment1 = EditableJavaMultiLineComment.builder().content("Something useful").build();
        JavaMultiLineComment comment2 = EditableJavaMultiLineComment.builder().content("Something else useful").build();
        try {
            JavaCodeTypeTest.assertMultiLineCommentEquals((JavaMultiLineComment)comment1, (JavaMultiLineComment)comment2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Content differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)comment1, (Object)comment2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMultiLineCommentEqualsContentLength() {
        JavaMultiLineComment comment1 = EditableJavaMultiLineComment.builder().content("Something useful").content("Another line").build();
        JavaMultiLineComment comment2 = EditableJavaMultiLineComment.builder().content("Something useful").build();
        try {
            JavaCodeTypeTest.assertMultiLineCommentEquals((JavaMultiLineComment)comment1, (JavaMultiLineComment)comment2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Content length is different!\nContent differs on #2!", (String)AssertionFailedErrors.buildAssertError((Object)comment1, (Object)comment2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertMultiLineCommentEqualsAll() {
        JavaMultiLineComment comment1 = UneditableJavaMultiLineComment.builder().content("Something useful").build();
        JavaMultiLineComment comment2 = EditableJavaMultiLineComment.builder().content("Something else useful").content("Another line").build();
        try {
            JavaCodeTypeTest.assertMultiLineCommentEquals((JavaMultiLineComment)comment1, (JavaMultiLineComment)comment2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!\nContent length is different!\nContent differs on #1!", (String)AssertionFailedErrors.buildAssertError((Object)comment1, (Object)comment2)), (Object)e.getMessage());
        }
    }
}

