/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.UneditableJavaPackageDeclaration;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestPackageDeclarationTest {
    @Test
    public void testFindPackageDeclarationsDifferencesNone() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findPackageDeclarationDifferences((JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.test").build(), (JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.test").build()));
    }

    @Test
    public void testFindPackageDeclarationDifferencesBothNull() {
        Assertions.assertEquals(new ArrayList(), (Object)JavaCodeTypeTest.findPackageDeclarationDifferences(null, null));
    }

    @Test
    public void testFindPackageDeclarationDifferences1Null2Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the package declarations is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findPackageDeclarationDifferences(null, (JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.test").build()));
    }

    @Test
    public void testFindPackageDeclarationDifferences2Null1Not() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"One of the package declarations is null, and the other isn't!"}), (Object)JavaCodeTypeTest.findPackageDeclarationDifferences((JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.test").build(), null));
    }

    @Test
    public void testFindPackageDeclarationsDifferencesEditable() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!"}), (Object)JavaCodeTypeTest.findPackageDeclarationDifferences((JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.test").build(), (JavaPackageDeclaration)UneditableJavaPackageDeclaration.builder().packageName("com.test").build()));
    }

    @Test
    public void testFindPackageDeclarationsDifferencesPackageName() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Package Name is different!"}), (Object)JavaCodeTypeTest.findPackageDeclarationDifferences((JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.test").build(), (JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.derp").build()));
    }

    @Test
    public void testFindPackageDeclarationsDifferencesAll() {
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Editable is different!", "Package Name is different!"}), (Object)JavaCodeTypeTest.findPackageDeclarationDifferences((JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.test").build(), (JavaPackageDeclaration)UneditableJavaPackageDeclaration.builder().packageName("com.derp").build()));
    }

    @Test
    public void testAssertPackageDeclarationEqualsNone() {
        JavaCodeTypeTest.assertPackageDeclarationEquals((JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.test").build(), (JavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.test").build());
    }

    @Test
    public void testAssertPackageDeclarationEqualsBothNull() {
        JavaCodeTypeTest.assertPackageDeclarationEquals(null, null);
    }

    @Test
    public void testAssertPackageDeclarationEquals1Null2Not() {
        JavaPackageDeclaration declaration2 = EditableJavaPackageDeclaration.builder().packageName("com.test").build();
        try {
            JavaCodeTypeTest.assertPackageDeclarationEquals(null, (JavaPackageDeclaration)declaration2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the package declarations is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError(null, (Object)declaration2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertPackageDeclarationEquals2Null1Not() {
        JavaPackageDeclaration declaration1 = EditableJavaPackageDeclaration.builder().packageName("com.test").build();
        try {
            JavaCodeTypeTest.assertPackageDeclarationEquals((JavaPackageDeclaration)declaration1, null);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"One of the package declarations is null, and the other isn't!", (String)AssertionFailedErrors.buildAssertError((Object)declaration1, null)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertPackageDeclarationEqualsEditable() {
        JavaPackageDeclaration declaration1 = EditableJavaPackageDeclaration.builder().packageName("com.test").build();
        JavaPackageDeclaration declaration2 = UneditableJavaPackageDeclaration.builder().packageName("com.test").build();
        try {
            JavaCodeTypeTest.assertPackageDeclarationEquals((JavaPackageDeclaration)declaration1, (JavaPackageDeclaration)declaration2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!", (String)AssertionFailedErrors.buildAssertError((Object)declaration1, (Object)declaration2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertPackageDeclarationEqualsPackageName() {
        JavaPackageDeclaration declaration1 = EditableJavaPackageDeclaration.builder().packageName("com.test").build();
        JavaPackageDeclaration declaration2 = EditableJavaPackageDeclaration.builder().packageName("com.derp").build();
        try {
            JavaCodeTypeTest.assertPackageDeclarationEquals((JavaPackageDeclaration)declaration1, (JavaPackageDeclaration)declaration2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Package Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)declaration1, (Object)declaration2)), (Object)e.getMessage());
        }
    }

    @Test
    public void testAssertPackageDeclarationEqualsAll() {
        JavaPackageDeclaration declaration1 = EditableJavaPackageDeclaration.builder().packageName("com.test").build();
        JavaPackageDeclaration declaration2 = UneditableJavaPackageDeclaration.builder().packageName("com.derp").build();
        try {
            JavaCodeTypeTest.assertPackageDeclarationEquals((JavaPackageDeclaration)declaration1, (JavaPackageDeclaration)declaration2);
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)"Editable is different!\nPackage Name is different!", (String)AssertionFailedErrors.buildAssertError((Object)declaration1, (Object)declaration2)), (Object)e.getMessage());
        }
    }
}

