/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javaclass.UneditableJavaClass;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestTest {
    @Test
    public void testCheckBooleanSuccess() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkBoolean((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Editable", JavaClass::isEditable);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckBooleanFailure() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = UneditableJavaClass.builder().className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkBoolean((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Editable", JavaClass::isEditable);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Editable is different!", differences.get(0));
    }

    @Test
    public void testCheckStringSuccess() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkString((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Class Name", JavaClass::getClassName);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckStringBlankSuccess() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").superClassName(null).build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Test").superClassName("").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkString((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Super Class Name", JavaClass::getSuperClassName);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckStringFailure() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").superClassName("Something").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Test").superClassName("Nothing").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkString((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Super Class Name", JavaClass::getSuperClassName);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Super Class Name is different!", differences.get(0));
    }

    @Test
    public void testRunParserForClassSuccess() throws JavaParsingException {
        EditableJavaClass clazz = JavaCodeTypeTest.runParserForClass((String)"class Test{ }");
        Assertions.assertEquals((Object)clazz, (Object)EditableJavaClass.builder().className("Test").build());
    }

    @Test
    public void testCheckListSuccessBothEmpty() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkList((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Implements Interface Names", JavaClass::getImplementsInterfaceNames, StringUtil::equals);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckListFailureFirstEmpty() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkList((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Implements Interface Names", JavaClass::getImplementsInterfaceNames, StringUtil::equals);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Implements Interface Names length is different!", differences.get(0));
    }

    @Test
    public void testCheckListSuccessNotEmpty() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkList((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Implements Interface Names", JavaClass::getImplementsInterfaceNames, StringUtil::equals);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckListFailure() {
        JavaClass clazz1 = EditableJavaClass.builder().className("Test").implementsInterfaceName("SomethingElse").build();
        JavaClass clazz2 = EditableJavaClass.builder().className("Test").implementsInterfaceName("Something").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkList((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Implements Interface Names", JavaClass::getImplementsInterfaceNames, StringUtil::equals);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Implements Interface Names differs on #1!", differences.get(0));
    }

    @Test
    public void testCheckEnumSuccess() {
        JavaClass clazz1 = EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkEnum((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Visibility", JavaClass::getVisibility);
        Assertions.assertTrue((boolean)differences.isEmpty());
    }

    @Test
    public void testCheckEnumFailure() {
        JavaClass clazz1 = EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build();
        JavaClass clazz2 = EditableJavaClass.builder().visibility(Visibility.PRIVATE).className("Test").build();
        ArrayList differences = new ArrayList();
        JavaCodeTypeTest.checkEnum((JavaCodeType)clazz1, (JavaCodeType)clazz2, differences, (String)"Visibility", JavaClass::getVisibility);
        Assertions.assertEquals((int)1, (int)differences.size());
        Assertions.assertEquals((Object)"Visibility is different!", differences.get(0));
    }

    @Test
    public void testRunParserForClassNotAClass() throws JavaParsingException {
        try {
            JavaCodeTypeTest.runParserForClass((String)"String test;");
            Assertions.fail();
        }
        catch (AssertionFailedError e) {
            Assertions.assertEquals((Object)AssertionFailedErrors.buildAssertError((Object)JavaCodeTypes.CLASS, (Object)JavaCodeTypes.FIELD), (Object)e.getMessage());
        }
    }
}

