/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.util.parallel;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.testing.JavaClassParsingTest;

public class ParallelWorkerTest
extends JavaClassParsingTest {
    public ParallelWorkerTest() {
        super("package com.github.tadukoo.util.parallel;\n\nimport com.github.tadukoo.util.logger.EasyLogger;\n\n/**\n * Parallel Worker is the class involved in parallel programming that actually does the work involved in the\n * parallel operation.\n * <br><br>\n * Subclasses you make of this class should have a constructor matching this class's constructor, because of\n * how {@link ParallelRunner} works for instantiating an instance of this class.\n * \n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.6\n * \n * @param <E> The type of the work object\n */\npublic abstract class ParallelWorker<E> implements Runnable{\n\t\n\t/** The {@link EasyLogger logger} to use for logging */\n\tprotected final EasyLogger logger;\n\t/** The {@link Queue} containing work that needs to be executed yet */\n\tprivate final Queue<E> todoQueue;\n\t/** The {@link Queue} to put finished work into */\n\tprivate final Queue<E> doneQueue;\n\t\n\t/**\n\t * Constructs a new {@link ParallelWorker} with the given parameters\n\t * \n\t * @param logger The {@link EasyLogger logger} to use for logging\n\t * @param todoQueue The {@link Queue} containing work that needs to be executed yet\n\t * @param doneQueue The {@link Queue} to put finished work into\n\t */\n\tpublic ParallelWorker(EasyLogger logger, Queue<E> todoQueue, Queue<E> doneQueue){\n\t\tthis.logger = logger;\n\t\tthis.todoQueue = todoQueue;\n\t\tthis.doneQueue = doneQueue;\n\t}\n\t\n\t/**\n\t * Used to run the actual worker. Runs forever until {@link #checkToContinueWork(Object)} returns false.\n\t * Each iteration it grabs work off the {@link #todoQueue}, checks if it is an object to terminate work,\n\t * and if not will call {@link #doWork(Object)} with the work object, then add that work to the {@link #doneQueue}\n\t */\n\t@Override\n\tpublic void run(){\n\t\tboolean cont = true;\n\t\twhile(cont){\n\t\t\ttry{\n\t\t\t\tE work = todoQueue.dequeue();\n\t\t\t\tif(checkToContinueWork(work)){\n\t\t\t\t\t// Do the actual work\n\t\t\t\t\tdoWork(work);\n\t\t\t\t\tdoneQueue.enqueue(work);\n\t\t\t\t}else{\n\t\t\t\t\tcont = false;\n\t\t\t\t}\n\t\t\t}catch(InterruptedException e){\n\t\t\t\tlogger.logError(e);\n\t\t\t}\n\t\t}\n\t}\n\t\n\t/**\n\t * Checks if the passed in work object is a terminate work object and returns {@code false} if it is\n\t * \n\t * @param work The work object to check\n\t * @return {@code true} if the object is a valid work object, {@code false} if it is a terminate work object\n\t */\n\tprotected abstract boolean checkToContinueWork(E work);\n\t\n\t/**\n\t * Do the work involved with the given work object\n\t * \n\t * @param work The work object to use to do the work\n\t */\n\tprotected abstract void doWork(E work);\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.util.parallel").importName("com.github.tadukoo.util.logger.EasyLogger", false).javadoc(EditableJavadoc.builder().content("Parallel Worker is the class involved in parallel programming that actually does the work involved in the").content("parallel operation.").content("<br><br>").content("Subclasses you make of this class should have a constructor matching this class's constructor, because of").content("how {@link ParallelRunner} works for instantiating an instance of this class.").author("Logan Ferree (Tadukoo)").version("Beta v.0.6").param("<E>", "The type of the work object").build()).visibility(Visibility.PUBLIC).isAbstract().className("ParallelWorker<E>").implementsInterfaceName("Runnable").field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("The {@link EasyLogger logger} to use for logging").build()).visibility(Visibility.PROTECTED).isFinal().type("EasyLogger").name("logger").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("The {@link Queue} containing work that needs to be executed yet").build()).visibility(Visibility.PRIVATE).isFinal().type("Queue<E>").name("todoQueue").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("The {@link Queue} to put finished work into").build()).visibility(Visibility.PRIVATE).isFinal().type("Queue<E>").name("doneQueue").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Constructs a new {@link ParallelWorker} with the given parameters").param("logger", "The {@link EasyLogger logger} to use for logging").param("todoQueue", "The {@link Queue} containing work that needs to be executed yet").param("doneQueue", "The {@link Queue} to put finished work into").build()).visibility(Visibility.PUBLIC).returnType("ParallelWorker").parameter("EasyLogger", "logger").parameter("Queue<E>", "todoQueue").parameter("Queue<E>", "doneQueue").line("this.logger = logger;").line("this.todoQueue = todoQueue;").line("this.doneQueue = doneQueue;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Used to run the actual worker. Runs forever until {@link #checkToContinueWork(Object)} returns false.").content("Each iteration it grabs work off the {@link #todoQueue}, checks if it is an object to terminate work,").content("and if not will call {@link #doWork(Object)} with the work object, then add that work to the {@link #doneQueue}").build()).annotation(EditableJavaAnnotation.builder().name("Override").build()).visibility(Visibility.PUBLIC).returnType("void").name("run").line("boolean cont = true;").line("while(cont){").line("\ttry{").line("\t\tE work = todoQueue.dequeue();").line("\t\tif(checkToContinueWork(work)){").line("\t\t\t// Do the actual work").line("\t\t\tdoWork(work);").line("\t\t\tdoneQueue.enqueue(work);").line("\t\t}else{").line("\t\t\tcont = false;").line("\t\t}").line("\t}catch(InterruptedException e){").line("\t\tlogger.logError(e);").line("\t}").line("}").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Checks if the passed in work object is a terminate work object and returns {@code false} if it is").param("work", "The work object to check").returnVal("{@code true} if the object is a valid work object, {@code false} if it is a terminate work object").build()).visibility(Visibility.PROTECTED).isAbstract().returnType("boolean").name("checkToContinueWork").parameter("E", "work").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Do the work involved with the given work object").param("work", "The work object to use to do the work").build()).visibility(Visibility.PROTECTED).isAbstract().returnType("void").name("doWork").parameter("E", "work").build()).build());
    }
}

