/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.util.parallel;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.testing.JavaClassParsingTest;

public class QueueTest
extends JavaClassParsingTest {
    public QueueTest() {
        super("package com.github.tadukoo.util.parallel;\n\nimport java.util.LinkedList;\n\n/**\n * This Queue is used to run parallel code with thread-safe methods for grabbing items off the queue and\n * putting items on the queue.\n * \n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.6\n * \n * @param <E> The type of item stored in this {@link Queue}\n */\npublic class Queue<E>{\n\t\n\t/** An object to use as a lock for synchronizing while running in parallel */\n\tprivate final Object lock = new Object();\n\t/** The actual data of the {@link Queue} */\n\tprivate final LinkedList<E> data;\n\t/** The maximum number of items that can be in the {@link Queue} */\n\tprivate final int maxItems;\n\t\n\t/**\n\t * Creates a new {@link Queue}\n\t * \n\t * @param maxItems The maximum number of items that can be in the {@link Queue}\n\t */\n\tpublic Queue(int maxItems){\n\t\tdata = new LinkedList<>();\n\t\tthis.maxItems = maxItems;\n\t}\n\t\n\t/**\n\t * Adds the given item to the {@link Queue}\n\t * \n\t * @param item The item to add to the {@link Queue}\n\t * @throws InterruptedException If something goes wrong in waiting for the lock\n\t */\n\tpublic void enqueue(E item) throws InterruptedException{\n\t\tsynchronized(lock){\n\t\t\t// Wait until we can add more to the queue\n\t\t\twhile(data.size() == maxItems){\n\t\t\t\tlock.wait();\n\t\t\t}\n\t\t\t// Add the item to the queue and release the lock\n\t\t\tdata.addLast(item);\n\t\t\tlock.notifyAll();\n\t\t}\n\t}\n\t\n\t/**\n\t * Takes an item off the {@link Queue}\n\t * \n\t * @return The item taken off the {@link Queue}\n\t * @throws InterruptedException If something goes wrong in waiting for the lock\n\t */\n\tpublic E dequeue() throws InterruptedException{\n\t\tsynchronized(lock){\n\t\t\t// Wait until there's something in the queue to take out\n\t\t\twhile(data.isEmpty()){\n\t\t\t\tlock.wait();\n\t\t\t}\n\t\t\t// Grab an item off the queue, release the lock, and return the grabbed item\n\t\t\tE item = data.removeFirst();\n\t\t\tlock.notifyAll();\n\t\t\treturn item;\n\t\t}\n\t}\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.util.parallel").importName("java.util.LinkedList", false).javadoc(EditableJavadoc.builder().content("This Queue is used to run parallel code with thread-safe methods for grabbing items off the queue and").content("putting items on the queue.").author("Logan Ferree (Tadukoo)").version("Beta v.0.6").param("<E>", "The type of item stored in this {@link Queue}").build()).visibility(Visibility.PUBLIC).className("Queue<E>").field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("An object to use as a lock for synchronizing while running in parallel").build()).visibility(Visibility.PRIVATE).isFinal().type("Object").name("lock").value("new Object()").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("The actual data of the {@link Queue}").build()).visibility(Visibility.PRIVATE).isFinal().type("LinkedList<E>").name("data").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("The maximum number of items that can be in the {@link Queue}").build()).visibility(Visibility.PRIVATE).isFinal().type("int").name("maxItems").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Creates a new {@link Queue}").param("maxItems", "The maximum number of items that can be in the {@link Queue}").build()).visibility(Visibility.PUBLIC).returnType("Queue").parameter("int", "maxItems").line("data = new LinkedList<>();").line("this.maxItems = maxItems;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Adds the given item to the {@link Queue}").param("item", "The item to add to the {@link Queue}").throwsInfo("InterruptedException", "If something goes wrong in waiting for the lock").build()).visibility(Visibility.PUBLIC).returnType("void").name("enqueue").parameter("E", "item").throwType("InterruptedException").line("synchronized(lock){").line("\t// Wait until we can add more to the queue").line("\twhile(data.size() == maxItems){").line("\t\tlock.wait();").line("\t}").line("\t// Add the item to the queue and release the lock").line("\tdata.addLast(item);").line("\tlock.notifyAll();").line("}").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Takes an item off the {@link Queue}").returnVal("The item taken off the {@link Queue}").throwsInfo("InterruptedException", "If something goes wrong in waiting for the lock").build()).visibility(Visibility.PUBLIC).returnType("E").name("dequeue").throwType("InterruptedException").line("synchronized(lock){").line("\t// Wait until there's something in the queue to take out").line("\twhile(data.isEmpty()){").line("\t\tlock.wait();").line("\t}").line("\t// Grab an item off the queue, release the lock, and return the grabbed item").line("\tE item = data.removeFirst();").line("\tlock.notifyAll();").line("\treturn item;").line("}").build()).build());
    }
}

