/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.parsing.FullJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.functional.function.ThrowingFunction2;
import com.github.tadukoo.util.functional.predicate.ThrowingPredicate2;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTest {
    public static <Type extends JavaCodeType> void checkBoolean(Type expectedObject, Type actualObject, List<String> differences, String valueName, ThrowingFunction<Type, Boolean, NoException> booleanMethod) {
        if (booleanMethod.apply(expectedObject) != booleanMethod.apply(actualObject)) {
            differences.add(valueName + " is different!");
        }
    }

    public static <Type extends JavaCodeType> void checkString(Type expectedObject, Type actualObject, List<String> differences, String valueName, ThrowingFunction<Type, String, NoException> stringMethod) {
        if (StringUtil.notEquals((String)((String)stringMethod.apply(expectedObject)), (String)((String)stringMethod.apply(actualObject))) && !StringUtil.allBlank((String[])new String[]{(String)stringMethod.apply(expectedObject), (String)stringMethod.apply(actualObject)})) {
            differences.add(valueName + " is different!");
        }
    }

    public static <Type extends JavaCodeType, ListType> void checkList(Type expectedObject, Type actualObject, List<String> differences, String valueName, ThrowingFunction<Type, List<ListType>, NoException> listMethod, ThrowingPredicate2<ListType, ListType, NoException> listItemCompareMethod) {
        List list1 = (List)listMethod.apply(expectedObject);
        List list2 = (List)listMethod.apply(actualObject);
        if (list1.size() != list2.size()) {
            differences.add(valueName + " length is different!");
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list2.size() > i && listItemCompareMethod.test(list1.get(i), list2.get(i))) continue;
            differences.add(valueName + " differs on #" + (i + 1) + "!");
        }
    }

    public static <Type extends JavaCodeType, E extends Enum<?>> void checkEnum(Type expectedObject, Type actualObject, List<String> differences, String valueName, ThrowingFunction<Type, E, NoException> enumMethod) {
        if (enumMethod.apply(expectedObject) != enumMethod.apply(actualObject)) {
            differences.add(valueName + " is different!");
        }
    }

    public static <Type extends JavaCodeType, Subtype extends JavaCodeType> void checkSingleSubtype(Type expectedObject, Type actualObject, List<String> differences, String subtypeName, ThrowingFunction<Type, Subtype, NoException> subtypeMethod, ThrowingFunction2<Subtype, Subtype, List<String>, NoException> subtypeDifferencesMethod) {
        JavaCodeType subtype2;
        JavaCodeType subtype1 = (JavaCodeType)subtypeMethod.apply(expectedObject);
        List subtypeDifferences = (List)subtypeDifferencesMethod.apply((Object)subtype1, (Object)(subtype2 = (JavaCodeType)subtypeMethod.apply(actualObject)));
        if (ListUtil.isNotBlank((List)subtypeDifferences)) {
            differences.add(subtypeName + " differs:\n\t" + StringUtil.buildStringWithSeparator((Collection)subtypeDifferences, (String)"\n\t"));
        }
    }

    public static <Type extends JavaCodeType, Subtype extends JavaCodeType> void checkListSubtype(Type expectedObject, Type actualObject, List<String> differences, String subtypeName, ThrowingFunction<Type, List<Subtype>, NoException> subtypeListMethod, ThrowingFunction2<Subtype, Subtype, List<String>, NoException> subtypeDifferencesMethod) {
        List subtypeList1 = (List)subtypeListMethod.apply(expectedObject);
        List subtypeList2 = (List)subtypeListMethod.apply(actualObject);
        if (subtypeList1.size() != subtypeList2.size()) {
            differences.add(subtypeName + " length is different!");
        }
        for (int i = 0; i < subtypeList1.size(); ++i) {
            if (subtypeList2.size() <= i) {
                differences.add(subtypeName + " differs on #" + (i + 1) + "!");
                continue;
            }
            List subtypeDifferences = (List)subtypeDifferencesMethod.apply((Object)((JavaCodeType)subtypeList1.get(i)), (Object)((JavaCodeType)subtypeList2.get(i)));
            if (!ListUtil.isNotBlank((List)subtypeDifferences)) continue;
            differences.add(subtypeName + " differs on #" + (i + 1) + ":\n\t" + StringUtil.buildStringWithSeparator((Collection)subtypeDifferences, (String)"\n\t"));
        }
    }

    public static EditableJavaClass runParserForClass(String content) throws JavaParsingException {
        JavaCodeType result = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.CLASS, (Object)result.getJavaCodeType());
        Assertions.assertInstanceOf(EditableJavaClass.class, (Object)result);
        return (EditableJavaClass)result;
    }

    public static <Type extends JavaCodeType> void baseAssertEquals(Type expectedObject, Type actualObject, ThrowingFunction2<Type, Type, List<String>, NoException> differencesMethod) {
        List differences = (List)differencesMethod.apply(expectedObject, actualObject);
        if (ListUtil.isNotBlank((List)differences)) {
            throw new AssertionFailedError(AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines((Collection)differences), (String)AssertionFailedErrors.buildAssertError(expectedObject, actualObject)));
        }
    }

    public static List<String> findPackageDeclarationDifferences(JavaPackageDeclaration expectedPackageDeclaration, JavaPackageDeclaration actualPackageDeclaration) {
        ArrayList<String> differences = new ArrayList<String>();
        if (expectedPackageDeclaration == null && actualPackageDeclaration == null) {
            return differences;
        }
        if (expectedPackageDeclaration == null || actualPackageDeclaration == null) {
            differences.add("One of the package declarations is null, and the other isn't!");
            return differences;
        }
        JavaCodeTypeTest.checkBoolean(expectedPackageDeclaration, actualPackageDeclaration, differences, "Editable", JavaPackageDeclaration::isEditable);
        JavaCodeTypeTest.checkString(expectedPackageDeclaration, actualPackageDeclaration, differences, "Package Name", JavaPackageDeclaration::getPackageName);
        return differences;
    }

    public static void assertPackageDeclarationEquals(JavaPackageDeclaration expectedPackageDeclaration, JavaPackageDeclaration actualPackageDeclaration) {
        JavaCodeTypeTest.baseAssertEquals(expectedPackageDeclaration, actualPackageDeclaration, JavaCodeTypeTest::findPackageDeclarationDifferences);
    }

    public static List<String> findImportStatementDifferences(JavaImportStatement expectedImportStatement, JavaImportStatement actualImportStatement) {
        ArrayList<String> differences = new ArrayList<String>();
        JavaCodeTypeTest.checkBoolean(expectedImportStatement, actualImportStatement, differences, "Editable", JavaImportStatement::isEditable);
        JavaCodeTypeTest.checkBoolean(expectedImportStatement, actualImportStatement, differences, "Static", JavaImportStatement::isStatic);
        JavaCodeTypeTest.checkString(expectedImportStatement, actualImportStatement, differences, "Import Name", JavaImportStatement::getImportName);
        return differences;
    }

    public static void assertImportStatementEquals(JavaImportStatement expectedImportStatement, JavaImportStatement actualImportStatement) {
        JavaCodeTypeTest.baseAssertEquals(expectedImportStatement, actualImportStatement, JavaCodeTypeTest::findImportStatementDifferences);
    }

    public static List<String> findJavadocDifferences(Javadoc expectedDoc, Javadoc actualDoc) {
        ArrayList<String> differences = new ArrayList<String>();
        if (expectedDoc == null && actualDoc == null) {
            return differences;
        }
        if (expectedDoc == null || actualDoc == null) {
            differences.add("One of the Javadocs is null, and the other isn't!");
            return differences;
        }
        JavaCodeTypeTest.checkBoolean(expectedDoc, actualDoc, differences, "Editable", Javadoc::isEditable);
        JavaCodeTypeTest.checkBoolean(expectedDoc, actualDoc, differences, "Condensed", Javadoc::isCondensed);
        JavaCodeTypeTest.checkList(expectedDoc, actualDoc, differences, "Content", Javadoc::getContent, StringUtil::equals);
        JavaCodeTypeTest.checkString(expectedDoc, actualDoc, differences, "Author", Javadoc::getAuthor);
        JavaCodeTypeTest.checkString(expectedDoc, actualDoc, differences, "Version", Javadoc::getVersion);
        JavaCodeTypeTest.checkString(expectedDoc, actualDoc, differences, "Since", Javadoc::getSince);
        JavaCodeTypeTest.checkList(expectedDoc, actualDoc, differences, "Params", Javadoc::getParams, Pair::equals);
        JavaCodeTypeTest.checkString(expectedDoc, actualDoc, differences, "Return", Javadoc::getReturnVal);
        JavaCodeTypeTest.checkList(expectedDoc, actualDoc, differences, "Throws", Javadoc::getThrowsInfos, Pair::equals);
        return differences;
    }

    public static void assertJavadocEquals(Javadoc expectedDoc, Javadoc actualDoc) {
        JavaCodeTypeTest.baseAssertEquals(expectedDoc, actualDoc, JavaCodeTypeTest::findJavadocDifferences);
    }

    public static List<String> findAnnotationDifferences(JavaAnnotation expectedAnnotation, JavaAnnotation actualAnnotation) {
        ArrayList<String> differences = new ArrayList<String>();
        if (expectedAnnotation == null && actualAnnotation == null) {
            return differences;
        }
        if (expectedAnnotation == null || actualAnnotation == null) {
            differences.add("One of the annotations is null, and the other isn't!");
            return differences;
        }
        JavaCodeTypeTest.checkBoolean(expectedAnnotation, actualAnnotation, differences, "Editable", JavaAnnotation::isEditable);
        JavaCodeTypeTest.checkString(expectedAnnotation, actualAnnotation, differences, "Name", JavaAnnotation::getName);
        JavaCodeTypeTest.checkString(expectedAnnotation, actualAnnotation, differences, "Canonical Name", JavaAnnotation::getCanonicalName);
        JavaCodeTypeTest.checkList(expectedAnnotation, actualAnnotation, differences, "Parameters", JavaAnnotation::getParameters, Pair::equals);
        return differences;
    }

    public static void assertAnnotationEquals(JavaAnnotation expectedAnnotation, JavaAnnotation actualAnnotation) {
        JavaCodeTypeTest.baseAssertEquals(expectedAnnotation, actualAnnotation, JavaCodeTypeTest::findAnnotationDifferences);
    }

    public static List<String> findSingleLineCommentDifferences(JavaSingleLineComment expectedComment, JavaSingleLineComment actualComment) {
        ArrayList<String> differences = new ArrayList<String>();
        if (expectedComment == null && actualComment == null) {
            return differences;
        }
        if (expectedComment == null || actualComment == null) {
            differences.add("One of the single-line comments is null, and the other isn't!");
            return differences;
        }
        JavaCodeTypeTest.checkBoolean(expectedComment, actualComment, differences, "Editable", JavaSingleLineComment::isEditable);
        JavaCodeTypeTest.checkString(expectedComment, actualComment, differences, "Content", JavaSingleLineComment::getContent);
        return differences;
    }

    public static void assertSingleLineCommentEquals(JavaSingleLineComment expectedComment, JavaSingleLineComment actualComment) {
        JavaCodeTypeTest.baseAssertEquals(expectedComment, actualComment, JavaCodeTypeTest::findSingleLineCommentDifferences);
    }

    public static List<String> findMultiLineCommentDifferences(JavaMultiLineComment expectedComment, JavaMultiLineComment actualComment) {
        ArrayList<String> differences = new ArrayList<String>();
        if (expectedComment == null && actualComment == null) {
            return differences;
        }
        if (expectedComment == null || actualComment == null) {
            differences.add("One of the multi-line comments is null, and the other isn't!");
            return differences;
        }
        JavaCodeTypeTest.checkBoolean(expectedComment, actualComment, differences, "Editable", JavaMultiLineComment::isEditable);
        JavaCodeTypeTest.checkList(expectedComment, actualComment, differences, "Content", JavaMultiLineComment::getContent, StringUtil::equals);
        return differences;
    }

    public static void assertMultiLineCommentEquals(JavaMultiLineComment expectedComment, JavaMultiLineComment actualComment) {
        JavaCodeTypeTest.baseAssertEquals(expectedComment, actualComment, JavaCodeTypeTest::findMultiLineCommentDifferences);
    }

    public static List<String> findFieldDifferences(JavaField expectedField, JavaField actualField) {
        ArrayList<String> differences = new ArrayList<String>();
        if (expectedField == null && actualField == null) {
            return differences;
        }
        if (expectedField == null || actualField == null) {
            differences.add("One of the fields is null, and the other isn't!");
            return differences;
        }
        JavaCodeTypeTest.checkBoolean(expectedField, actualField, differences, "Editable", JavaField::isEditable);
        JavaCodeTypeTest.checkSingleSubtype(expectedField, actualField, differences, "Javadoc", JavaField::getJavadoc, JavaCodeTypeTest::findJavadocDifferences);
        JavaCodeTypeTest.checkListSubtype(expectedField, actualField, differences, "Annotations", JavaField::getAnnotations, JavaCodeTypeTest::findAnnotationDifferences);
        JavaCodeTypeTest.checkEnum(expectedField, actualField, differences, "Visibility", JavaField::getVisibility);
        JavaCodeTypeTest.checkBoolean(expectedField, actualField, differences, "Static", JavaField::isStatic);
        JavaCodeTypeTest.checkBoolean(expectedField, actualField, differences, "Final", JavaField::isFinal);
        JavaCodeTypeTest.checkString(expectedField, actualField, differences, "Type", JavaField::getType);
        JavaCodeTypeTest.checkString(expectedField, actualField, differences, "Name", JavaField::getName);
        JavaCodeTypeTest.checkString(expectedField, actualField, differences, "Value", JavaField::getValue);
        return differences;
    }

    public static void assertFieldEquals(JavaField expectedField, JavaField actualField) {
        JavaCodeTypeTest.baseAssertEquals(expectedField, actualField, JavaCodeTypeTest::findFieldDifferences);
    }

    public static List<String> findMethodDifferences(JavaMethod expectedMethod, JavaMethod actualMethod) {
        ArrayList<String> differences = new ArrayList<String>();
        if (expectedMethod == null && actualMethod == null) {
            return differences;
        }
        if (expectedMethod == null || actualMethod == null) {
            differences.add("One of the methods is null, and the other isn't!");
            return differences;
        }
        JavaCodeTypeTest.checkBoolean(expectedMethod, actualMethod, differences, "Editable", JavaMethod::isEditable);
        JavaCodeTypeTest.checkSingleSubtype(expectedMethod, actualMethod, differences, "Javadoc", JavaMethod::getJavadoc, JavaCodeTypeTest::findJavadocDifferences);
        JavaCodeTypeTest.checkListSubtype(expectedMethod, actualMethod, differences, "Annotations", JavaMethod::getAnnotations, JavaCodeTypeTest::findAnnotationDifferences);
        JavaCodeTypeTest.checkEnum(expectedMethod, actualMethod, differences, "Visibility", JavaMethod::getVisibility);
        JavaCodeTypeTest.checkBoolean(expectedMethod, actualMethod, differences, "Abstract", JavaMethod::isAbstract);
        JavaCodeTypeTest.checkBoolean(expectedMethod, actualMethod, differences, "Static", JavaMethod::isStatic);
        JavaCodeTypeTest.checkBoolean(expectedMethod, actualMethod, differences, "Final", JavaMethod::isFinal);
        JavaCodeTypeTest.checkString(expectedMethod, actualMethod, differences, "Return Type", JavaMethod::getReturnType);
        JavaCodeTypeTest.checkString(expectedMethod, actualMethod, differences, "Name", JavaMethod::getName);
        JavaCodeTypeTest.checkList(expectedMethod, actualMethod, differences, "Parameters", JavaMethod::getParameters, Pair::equals);
        JavaCodeTypeTest.checkList(expectedMethod, actualMethod, differences, "Throw Types", JavaMethod::getThrowTypes, StringUtil::equals);
        JavaCodeTypeTest.checkList(expectedMethod, actualMethod, differences, "Content", JavaMethod::getLines, StringUtil::equals);
        return differences;
    }

    public static void assertMethodEquals(JavaMethod expectedMethod, JavaMethod actualMethod) {
        JavaCodeTypeTest.baseAssertEquals(expectedMethod, actualMethod, JavaCodeTypeTest::findMethodDifferences);
    }

    public static List<String> findClassDifferences(JavaClass expectedClass, JavaClass actualClass) {
        ArrayList<String> differences = new ArrayList<String>();
        if (expectedClass == null && actualClass == null) {
            return differences;
        }
        if (expectedClass == null || actualClass == null) {
            differences.add("One of the classes is null, and the other isn't!");
            return differences;
        }
        JavaCodeTypeTest.checkBoolean(expectedClass, actualClass, differences, "Editable", JavaClass::isEditable);
        JavaCodeTypeTest.checkBoolean(expectedClass, actualClass, differences, "Inner Class", JavaClass::isInnerClass);
        JavaCodeTypeTest.checkSingleSubtype(expectedClass, actualClass, differences, "Package Declaration", JavaClass::getPackageDeclaration, JavaCodeTypeTest::findPackageDeclarationDifferences);
        JavaCodeTypeTest.checkListSubtype(expectedClass, actualClass, differences, "Import Statements", JavaClass::getImportStatements, JavaCodeTypeTest::findImportStatementDifferences);
        JavaCodeTypeTest.checkSingleSubtype(expectedClass, actualClass, differences, "Javadoc", JavaClass::getJavadoc, JavaCodeTypeTest::findJavadocDifferences);
        JavaCodeTypeTest.checkListSubtype(expectedClass, actualClass, differences, "Annotations", JavaClass::getAnnotations, JavaCodeTypeTest::findAnnotationDifferences);
        JavaCodeTypeTest.checkEnum(expectedClass, actualClass, differences, "Visibility", JavaClass::getVisibility);
        JavaCodeTypeTest.checkBoolean(expectedClass, actualClass, differences, "Abstract", JavaClass::isAbstract);
        JavaCodeTypeTest.checkBoolean(expectedClass, actualClass, differences, "Static", JavaClass::isStatic);
        JavaCodeTypeTest.checkBoolean(expectedClass, actualClass, differences, "Final", JavaClass::isFinal);
        JavaCodeTypeTest.checkString(expectedClass, actualClass, differences, "Class Name", JavaClass::getClassName);
        JavaCodeTypeTest.checkString(expectedClass, actualClass, differences, "Super Class Name", JavaClass::getSuperClassName);
        JavaCodeTypeTest.checkList(expectedClass, actualClass, differences, "Implements Interface Names", JavaClass::getImplementsInterfaceNames, StringUtil::equals);
        JavaCodeTypeTest.checkListSubtype(expectedClass, actualClass, differences, "Single Line Comments", JavaClass::getSingleLineComments, JavaCodeTypeTest::findSingleLineCommentDifferences);
        JavaCodeTypeTest.checkListSubtype(expectedClass, actualClass, differences, "Multi Line Comments", JavaClass::getMultiLineComments, JavaCodeTypeTest::findMultiLineCommentDifferences);
        JavaCodeTypeTest.checkListSubtype(expectedClass, actualClass, differences, "Inner Classes", JavaClass::getInnerClasses, JavaCodeTypeTest::findClassDifferences);
        JavaCodeTypeTest.checkListSubtype(expectedClass, actualClass, differences, "Fields", JavaClass::getFields, JavaCodeTypeTest::findFieldDifferences);
        JavaCodeTypeTest.checkListSubtype(expectedClass, actualClass, differences, "Methods", JavaClass::getMethods, JavaCodeTypeTest::findMethodDifferences);
        JavaCodeTypeTest.checkList(expectedClass, actualClass, differences, "Inner Elements Order", JavaClass::getInnerElementsOrder, Pair::equals);
        return differences;
    }

    public static void assertClassEquals(JavaClass expectedClass, JavaClass actualClass) {
        JavaCodeTypeTest.baseAssertEquals(expectedClass, actualClass, JavaCodeTypeTest::findClassDifferences);
    }
}

