/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestJavadocTest {
    @ParameterizedTest
    @MethodSource(value={"getJavadocDifferences"})
    public void testFindJavadocDifferences(Javadoc expectedJavadoc, Javadoc actualJavadoc, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findJavadocDifferences((Javadoc)expectedJavadoc, (Javadoc)actualJavadoc));
    }

    @ParameterizedTest
    @MethodSource(value={"getJavadocDifferences"})
    public void testAssertJavadocEquals(Javadoc expectedJavadoc, Javadoc actualJavadoc, List<String> differences) {
        try {
            JavaCodeTypeTest.assertJavadocEquals((Javadoc)expectedJavadoc, (Javadoc)actualJavadoc);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedJavadoc, (Object)actualJavadoc)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getJavadocDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavadoc.builder().build(), EditableJavadoc.builder().build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, EditableJavadoc.builder().build(), ListUtil.createList((Object[])new String[]{"One of the Javadocs is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().build(), null, ListUtil.createList((Object[])new String[]{"One of the Javadocs is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{UneditableJavadoc.builder().build(), EditableJavadoc.builder().build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().condensed().build(), EditableJavadoc.builder().condensed(false).build(), ListUtil.createList((Object[])new String[]{"Condensed is different!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().content("something").build(), EditableJavadoc.builder().content("yep").build(), ListUtil.createList((Object[])new String[]{"Content differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().content("something").build(), EditableJavadoc.builder().content("something").content("yep").build(), ListUtil.createList((Object[])new String[]{"Content length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().content("something").content("yep").build(), EditableJavadoc.builder().content("something").build(), ListUtil.createList((Object[])new String[]{"Content length is different!", "Content differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().author("Logan Ferree (Tadukoo)").build(), EditableJavadoc.builder().author("Logan Ferree").build(), ListUtil.createList((Object[])new String[]{"Author is different!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().version("Alpha v.0.1").build(), EditableJavadoc.builder().version("Pre-Alpha").build(), ListUtil.createList((Object[])new String[]{"Version is different!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().since("Pre-Alpha").build(), EditableJavadoc.builder().since("Alpha v.0.1").build(), ListUtil.createList((Object[])new String[]{"Since is different!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().param("String", "something").build(), EditableJavadoc.builder().param("String", "something").param("int", "version").build(), ListUtil.createList((Object[])new String[]{"Params length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().param("String", "something").param("int", "version").build(), EditableJavadoc.builder().param("String", "something").build(), ListUtil.createList((Object[])new String[]{"Params length is different!", "Params differs on #2!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().returnVal("null").build(), EditableJavadoc.builder().returnVal("true if true").build(), ListUtil.createList((Object[])new String[]{"Return is different!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").build(), EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").throwsInfo("IllegalArgumentException", "why not?").build(), ListUtil.createList((Object[])new String[]{"Throws length is different!"})}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").throwsInfo("IllegalArgumentException", "why not?").build(), EditableJavadoc.builder().throwsInfo("IllegalStateException", "something").build(), ListUtil.createList((Object[])new String[]{"Throws length is different!", "Throws differs on #2!"})}), Arguments.of((Object[])new Object[]{UneditableJavadoc.builder().condensed().content("something").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Pre-Alpha").param("String", "somethingElse").returnVal("null").throwsInfo("IllegalStateException", "something").build(), EditableJavadoc.builder().condensed(false).content("yep").content("nope").author("Logan Ferree").version("Pre-Alpha").since("Alpha v.0.1").param("String", "something").param("int", "version").returnVal("true if true").throwsInfo("IllegalStateException", "somethingElse").throwsInfo("IllegalArgumentException", "why not?").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Condensed is different!", "Content length is different!", "Content differs on #1!", "Author is different!", "Version is different!", "Since is different!", "Params length is different!", "Params differs on #1!", "Return is different!", "Throws length is different!", "Throws differs on #1!"})}));
    }
}

