/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.UneditableJavaMultiLineComment;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestMultiLineCommentTest {
    @ParameterizedTest
    @MethodSource(value={"getCommentDifferences"})
    public void testFindMultiLineCommentDifferences(JavaMultiLineComment expectedComment, JavaMultiLineComment actualComment, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findMultiLineCommentDifferences((JavaMultiLineComment)expectedComment, (JavaMultiLineComment)actualComment));
    }

    @ParameterizedTest
    @MethodSource(value={"getCommentDifferences"})
    public void testAssertMultiLineCommentEquals(JavaMultiLineComment expectedComment, JavaMultiLineComment actualComment, List<String> differences) {
        try {
            JavaCodeTypeTest.assertMultiLineCommentEquals((JavaMultiLineComment)expectedComment, (JavaMultiLineComment)actualComment);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedComment, (Object)actualComment)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getCommentDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavaMultiLineComment.builder().content("Something useful").build(), EditableJavaMultiLineComment.builder().content("Something useful").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, EditableJavaMultiLineComment.builder().content("Something useful").build(), ListUtil.createList((Object[])new String[]{"One of the multi-line comments is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaMultiLineComment.builder().content("Something useful").build(), null, ListUtil.createList((Object[])new String[]{"One of the multi-line comments is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{UneditableJavaMultiLineComment.builder().content("Something useful").build(), EditableJavaMultiLineComment.builder().content("Something useful").build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaMultiLineComment.builder().content("Something useful").build(), EditableJavaMultiLineComment.builder().content("Something else useful").build(), ListUtil.createList((Object[])new String[]{"Content differs on #1!"})}), Arguments.of((Object[])new Object[]{EditableJavaMultiLineComment.builder().content("Something useful").content("Another line").build(), EditableJavaMultiLineComment.builder().content("Something useful").build(), ListUtil.createList((Object[])new String[]{"Content length is different!", "Content differs on #2!"})}), Arguments.of((Object[])new Object[]{UneditableJavaMultiLineComment.builder().content("Something useful").build(), EditableJavaMultiLineComment.builder().content("Something else useful").content("Another line").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Content length is different!", "Content differs on #1!"})}));
    }
}

