/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing;

import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.comment.UneditableJavaSingleLineComment;
import com.github.tadukoo.java.testing.JavaCodeTypeTest;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.junit.AssertionFailedErrors;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.AssertionFailedError;

public class JavaCodeTypeTestSingleLineCommentTest {
    @ParameterizedTest
    @MethodSource(value={"getCommentDifferences"})
    public void testFindSingleLineCommentDifferences(JavaSingleLineComment expectedComment, JavaSingleLineComment actualComment, List<String> differences) {
        Assertions.assertEquals(differences, (Object)JavaCodeTypeTest.findSingleLineCommentDifferences((JavaSingleLineComment)expectedComment, (JavaSingleLineComment)actualComment));
    }

    @ParameterizedTest
    @MethodSource(value={"getCommentDifferences"})
    public void testAssertSingleLineCommentEquals(JavaSingleLineComment expectedComment, JavaSingleLineComment actualComment, List<String> differences) {
        try {
            JavaCodeTypeTest.assertSingleLineCommentEquals((JavaSingleLineComment)expectedComment, (JavaSingleLineComment)actualComment);
            if (ListUtil.isNotBlank(differences)) {
                Assertions.fail();
            }
        }
        catch (AssertionFailedError e) {
            if (ListUtil.isBlank(differences)) {
                throw e;
            }
            Assertions.assertEquals((Object)AssertionFailedErrors.buildTwoPartError((String)StringUtil.buildStringWithNewLines(differences), (String)AssertionFailedErrors.buildAssertError((Object)expectedComment, (Object)actualComment)), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getCommentDifferences() {
        return Stream.of(Arguments.of((Object[])new Object[]{EditableJavaSingleLineComment.builder().content("Something useful").build(), EditableJavaSingleLineComment.builder().content("Something useful").build(), new ArrayList()}), Arguments.of((Object[])new Object[]{null, null, new ArrayList()}), Arguments.of((Object[])new Object[]{null, EditableJavaSingleLineComment.builder().content("Something useful").build(), ListUtil.createList((Object[])new String[]{"One of the single-line comments is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{EditableJavaSingleLineComment.builder().content("Something useful").build(), null, ListUtil.createList((Object[])new String[]{"One of the single-line comments is null, and the other isn't!"})}), Arguments.of((Object[])new Object[]{UneditableJavaSingleLineComment.builder().content("Something useful").build(), EditableJavaSingleLineComment.builder().content("Something useful").build(), ListUtil.createList((Object[])new String[]{"Editable is different!"})}), Arguments.of((Object[])new Object[]{EditableJavaSingleLineComment.builder().content("Something useful").build(), EditableJavaSingleLineComment.builder().content("Something else useful").build(), ListUtil.createList((Object[])new String[]{"Content is different!"})}), Arguments.of((Object[])new Object[]{UneditableJavaSingleLineComment.builder().content("Something useful").build(), EditableJavaSingleLineComment.builder().content("Something else useful").build(), ListUtil.createList((Object[])new String[]{"Editable is different!", "Content is different!"})}));
    }
}

