/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.util;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.testing.JavaClassParsingTest;

public class LoggerUtilTest
extends JavaClassParsingTest {
    public LoggerUtilTest() {
        super("package com.github.tadukoo.util;\n\nimport java.io.IOException;\nimport java.util.logging.FileHandler;\nimport java.util.logging.Level;\nimport java.util.logging.Logger;\nimport java.util.logging.SimpleFormatter;\n\n/**\n * Util functions for dealing with Loggers.\n * \n * @author Logan Ferree (Tadukoo)\n * @version 0.1-Alpha-SNAPSHOT\n */\npublic final class LoggerUtil{\n\t\n\t/** Not allowed to create a LoggerUtil */\n\tprivate LoggerUtil(){ }\n\t\n\t/**\n\t * Creates a new {@link Logger} for the given file with the given {@link Level}\n\t * of logging.\n\t * \n\t * @param filepath The path to the File to be used as a log\n\t * @param level The Level to log messages at\n\t * @return The created Logger\n\t * @throws IOException If something goes wrong in creating the file logger\n\t */\n\tpublic static Logger createFileLogger(String filepath, Level level) throws IOException{\n\t\t// Create the file\n\t\tFileUtil.createFile(filepath);\n\t\t\n\t\t// Setup a FileHandler for the File with a SimpleFormatter\n\t\tFileHandler fh = new FileHandler(filepath, true);\n\t\tSimpleFormatter formatter = new SimpleFormatter();\n\t\tfh.setFormatter(formatter);\n\t\t\n\t\t// Create the Logger with the given level and the created FileHandler\n\t\tLogger logger = Logger.getLogger(filepath);\n\t\tlogger.setLevel(level);\n\t\tlogger.addHandler(fh);\n\t\t\n\t\t// Return the newly created Logger\n\t\treturn logger;\n\t}\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.util").importName("java.io.IOException", false).importName("java.util.logging.FileHandler", false).importName("java.util.logging.Level", false).importName("java.util.logging.Logger", false).importName("java.util.logging.SimpleFormatter", false).javadoc(EditableJavadoc.builder().content("Util functions for dealing with Loggers.").author("Logan Ferree (Tadukoo)").version("0.1-Alpha-SNAPSHOT").build()).visibility(Visibility.PUBLIC).isFinal().className("LoggerUtil").method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("Not allowed to create a LoggerUtil").build()).visibility(Visibility.PRIVATE).returnType("LoggerUtil").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Creates a new {@link Logger} for the given file with the given {@link Level}").content("of logging.").param("filepath", "The path to the File to be used as a log").param("level", "The Level to log messages at").returnVal("The created Logger").throwsInfo("IOException", "If something goes wrong in creating the file logger").build()).visibility(Visibility.PUBLIC).isStatic().returnType("Logger").name("createFileLogger").parameter("String filepath").parameter("Level level").throwType("IOException").line("// Create the file").line("FileUtil.createFile(filepath);").line("").line("// Setup a FileHandler for the File with a SimpleFormatter").line("FileHandler fh = new FileHandler(filepath, true);").line("SimpleFormatter formatter = new SimpleFormatter();").line("fh.setFormatter(formatter);").line("").line("// Create the Logger with the given level and the created FileHandler").line("Logger logger = Logger.getLogger(filepath);").line("logger.setLevel(level);").line("logger.addHandler(fh);").line("").line("// Return the newly created Logger").line("return logger;").build()).build());
    }
}

