/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.testing.util.time;

import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.testing.JavaClassParsingTest;

public class MonthUtilTest
extends JavaClassParsingTest {
    public MonthUtilTest() {
        super("package com.github.tadukoo.util.time;\n\nimport com.github.tadukoo.util.StringUtil;\n\nimport java.time.Month;\nimport java.time.format.TextStyle;\nimport java.util.Locale;\n\n/**\n * Month Util provides utilities for dealing with {@link Month}s.\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.2.1\n */\npublic final class MonthUtil{\n\t\n\t/** Can't create a MonthUtil */\n\tprivate MonthUtil(){ }\n\t\n\t/**\n\t * Parses a {@link Month} from the given string. May return null if none match.\n\t * \n\t * @param str The string to be parsed into a {@link Month}\n\t * @return The {@link Month} matching the given string, or null\n\t */\n\tpublic static Month parseFromString(String str){\n\t\tfor(Month month: Month.values()){\n\t\t\tif(StringUtil.equalsIgnoreCase(str, month.toString())){\n\t\t\t\treturn month;\n\t\t\t}\n\t\t}\n\t\treturn null;\n\t}\n\t\n\t/**\n\t * Converts the given {@link Month} to its full, capitalized, US-Locale string. This is an\n\t * easy way instead of having to call {@link Month#getDisplayName(TextStyle, Locale)} all the time.\n\t * \n\t * @param month The {@link Month} to get as a string\n\t * @return The full string of the {@link Month}\n\t */\n\tpublic static String asString(Month month){\n\t\treturn month.getDisplayName(TextStyle.FULL, Locale.US);\n\t}\n\t\n\t/**\n\t * Creates a String array of the {@link Month}s.\n\t * \n\t * @return A String array of the {@link Month}s\n\t */\n\tpublic static String[] asStringArray(){\n\t\tString[] monthStrings = new String[12];\n\t\tint i = 0;\n\t\tfor(Month month: Month.values()){\n\t\t\tmonthStrings[i] = asString(month);\n\t\t\ti++;\n\t\t}\n\t\treturn monthStrings;\n\t}\n}\n", EditableJavaClass.builder().packageName("com.github.tadukoo.util.time").importName("com.github.tadukoo.util.StringUtil", false).importName("java.time.Month", false).importName("java.time.format.TextStyle", false).importName("java.util.Locale", false).javadoc(EditableJavadoc.builder().content("Month Util provides utilities for dealing with {@link Month}s.").author("Logan Ferree (Tadukoo)").version("Alpha v.0.2.1").build()).visibility(Visibility.PUBLIC).isFinal().className("MonthUtil").method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("Can't create a MonthUtil").build()).visibility(Visibility.PRIVATE).returnType("MonthUtil").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Parses a {@link Month} from the given string. May return null if none match.").param("str", "The string to be parsed into a {@link Month}").returnVal("The {@link Month} matching the given string, or null").build()).visibility(Visibility.PUBLIC).isStatic().returnType("Month").name("parseFromString").parameter("String str").line("for(Month month: Month.values()){").line("\tif(StringUtil.equalsIgnoreCase(str, month.toString())){").line("\t\treturn month;").line("\t}").line("}").line("return null;").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Converts the given {@link Month} to its full, capitalized, US-Locale string. This is an").content("easy way instead of having to call {@link Month#getDisplayName(TextStyle, Locale)} all the time.").param("month", "The {@link Month} to get as a string").returnVal("The full string of the {@link Month}").build()).visibility(Visibility.PUBLIC).isStatic().returnType("String").name("asString").parameter("Month month").line("return month.getDisplayName(TextStyle.FULL, Locale.US);").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().content("Creates a String array of the {@link Month}s.").returnVal("A String array of the {@link Month}s").build()).visibility(Visibility.PUBLIC).isStatic().returnType("String[]").name("asStringArray").line("String[] monthStrings = new String[12];").line("int i = 0;").line("for(Month month: Month.values()){").line("\tmonthStrings[i] = asString(month);").line("\ti++;").line("}").line("return monthStrings;").build()).build());
    }
}

