/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaAnnotationBuilder;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaAnnotationTest<AnnotationType extends JavaAnnotation> {
    private final ThrowingSupplier<JavaAnnotationBuilder<AnnotationType>, NoException> builder;
    protected String name;
    protected AnnotationType annotation;

    protected DefaultJavaAnnotationTest(ThrowingSupplier<JavaAnnotationBuilder<AnnotationType>, NoException> builder) {
        this.builder = builder;
    }

    @BeforeEach
    public void setup() {
        this.name = "Test";
        this.annotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).build();
    }

    @Test
    public void testBuilderName() {
        Assertions.assertEquals((Object)this.name, (Object)this.annotation.getName());
    }

    @Test
    public void testBuilderMissingName() {
        try {
            this.annotation = ((JavaAnnotationBuilder)this.builder.get()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify name!", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"@Test", (Object)this.annotation.toString());
    }

    @Test
    public void testEquals() {
        JavaAnnotation otherAnnotation = ((JavaAnnotationBuilder)this.builder.get()).name(this.name).build();
        Assertions.assertEquals(this.annotation, (Object)otherAnnotation);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaAnnotation otherAnnotation = ((JavaAnnotationBuilder)this.builder.get()).name("Testing").build();
        Assertions.assertNotEquals(this.annotation, (Object)otherAnnotation);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals(this.annotation, (Object)"testing");
    }
}

