/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaAnnotationBuilder;
import com.github.tadukoo.java.JavaClass;
import com.github.tadukoo.java.JavaClassBuilder;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaFieldBuilder;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.JavaMethodBuilder;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.JavadocBuilder;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaClassTest<ClassType extends JavaClass> {
    private final ThrowingSupplier<JavaClassBuilder<ClassType>, NoException> builder;
    private final ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder;
    private final ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder;
    private final ThrowingSupplier<JavaFieldBuilder<?>, NoException> javaFieldBuilder;
    private final ThrowingSupplier<JavaMethodBuilder<?>, NoException> javaMethodBuilder;
    protected ClassType clazz;
    protected String packageName;
    protected String className;

    protected DefaultJavaClassTest(ThrowingSupplier<JavaClassBuilder<ClassType>, NoException> builder, ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder, ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder, ThrowingSupplier<JavaFieldBuilder<?>, NoException> javaFieldBuilder, ThrowingSupplier<JavaMethodBuilder<?>, NoException> javaMethodBuilder) {
        this.builder = builder;
        this.javaAnnotationBuilder = javaAnnotationBuilder;
        this.javadocBuilder = javadocBuilder;
        this.javaFieldBuilder = javaFieldBuilder;
        this.javaMethodBuilder = javaMethodBuilder;
    }

    @BeforeEach
    public void setup() {
        this.packageName = "some.package";
        this.className = "AClassName";
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).build();
    }

    @Test
    public void testDefaultIsInnerClass() {
        Assertions.assertFalse((boolean)this.clazz.isInnerClass());
    }

    @Test
    public void testDefaultImports() {
        Assertions.assertNotNull((Object)this.clazz.getImports());
        Assertions.assertTrue((boolean)this.clazz.getImports().isEmpty());
    }

    @Test
    public void testDefaultStaticImports() {
        Assertions.assertNotNull((Object)this.clazz.getStaticImports());
        Assertions.assertTrue((boolean)this.clazz.getStaticImports().isEmpty());
    }

    @Test
    public void testDefaultJavadoc() {
        Assertions.assertNull((Object)this.clazz.getJavadoc());
    }

    @Test
    public void testDefaultAnnotations() {
        Assertions.assertNotNull((Object)this.clazz.getAnnotations());
        Assertions.assertTrue((boolean)this.clazz.getAnnotations().isEmpty());
    }

    @Test
    public void testDefaultVisibility() {
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)this.clazz.getVisibility());
    }

    @Test
    public void testDefaultIsStatic() {
        Assertions.assertFalse((boolean)this.clazz.isStatic());
    }

    @Test
    public void testDefaultSuperClassName() {
        Assertions.assertNull((Object)this.clazz.getSuperClassName());
    }

    @Test
    public void testDefaultFields() {
        Assertions.assertNotNull((Object)this.clazz.getFields());
        Assertions.assertTrue((boolean)this.clazz.getFields().isEmpty());
    }

    @Test
    public void testBuilderSetIsInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).isInnerClass(true).build();
        Assertions.assertTrue((boolean)this.clazz.isInnerClass());
    }

    @Test
    public void testBuilderSetInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).innerClass().build();
        Assertions.assertTrue((boolean)this.clazz.isInnerClass());
    }

    @Test
    public void testBuilderSetPackageName() {
        Assertions.assertEquals((Object)this.packageName, (Object)this.clazz.getPackageName());
    }

    @Test
    public void testBuilderSetClassName() {
        Assertions.assertEquals((Object)this.className, (Object)this.clazz.getClassName());
    }

    @Test
    public void testBuilderSetImports() {
        List imports = ListUtil.createList((Object[])new String[]{"com.example.*", "com.github.tadukoo.*"});
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).imports(imports).build();
        Assertions.assertEquals((Object)imports, (Object)this.clazz.getImports());
    }

    @Test
    public void testBuilderSetSingleImport() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).singleImport("com.example.*").build();
        List imports = this.clazz.getImports();
        Assertions.assertEquals((int)1, (int)imports.size());
        Assertions.assertEquals((Object)"com.example.*", imports.get(0));
    }

    @Test
    public void testBuilderSetStaticImports() {
        List staticImports = ListUtil.createList((Object[])new String[]{"com.example.Test", "com.github.tadukoo.*"});
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).staticImports(staticImports).build();
        Assertions.assertEquals((Object)staticImports, (Object)this.clazz.getStaticImports());
    }

    @Test
    public void testBuilderSetSingleStaticImport() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).staticImport("com.github.tadukoo.*").build();
        List staticImports = this.clazz.getStaticImports();
        Assertions.assertEquals((int)1, (int)staticImports.size());
        Assertions.assertEquals((Object)"com.github.tadukoo.*", staticImports.get(0));
    }

    @Test
    public void testBuilderSetJavadoc() {
        Javadoc doc = ((JavadocBuilder)this.javadocBuilder.get()).build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).javadoc(doc).build();
        Assertions.assertEquals((Object)doc, (Object)this.clazz.getJavadoc());
    }

    @Test
    public void testBuilderSetAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).annotations(annotations).build();
        Assertions.assertEquals((Object)annotations, (Object)this.clazz.getAnnotations());
    }

    @Test
    public void testBuilderSetSingleAnnotation() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).annotation(test).build();
        List annotations = this.clazz.getAnnotations();
        Assertions.assertEquals((int)1, (int)annotations.size());
        Assertions.assertEquals((Object)test, annotations.get(0));
    }

    @Test
    public void testBuilderSetVisibility() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).visibility(Visibility.PRIVATE).build();
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)this.clazz.getVisibility());
    }

    @Test
    public void testBuilderSetIsStatic() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).isStatic(true).build();
        Assertions.assertTrue((boolean)this.clazz.isStatic());
    }

    @Test
    public void testBuilderSetIsStaticNoParam() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).isStatic().build();
        Assertions.assertTrue((boolean)this.clazz.isStatic());
    }

    @Test
    public void testBuilderSetSuperClassName() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).superClassName("AnotherClassName").build();
        Assertions.assertEquals((Object)"AnotherClassName", (Object)this.clazz.getSuperClassName());
    }

    @Test
    public void testBuilderSetInnerClasses() {
        List classes = ListUtil.createList((Object[])new JavaClass[]{((JavaClassBuilder)this.builder.get()).innerClass().className("AClass").build(), ((JavaClassBuilder)this.builder.get()).innerClass().className("BClass").build()});
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className("CClassName").innerClasses(classes).build();
        Assertions.assertEquals((Object)classes, (Object)this.clazz.getInnerClasses());
    }

    @Test
    public void testBuilderSet1InnerClass() {
        JavaClass class2 = ((JavaClassBuilder)this.builder.get()).innerClass().className("AClass").build();
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className("BClassName").innerClass(class2).build();
        List innerClasses = this.clazz.getInnerClasses();
        Assertions.assertEquals((int)1, (int)innerClasses.size());
        Assertions.assertEquals((Object)class2, innerClasses.get(0));
    }

    @Test
    public void testBuilderSetFields() {
        List fields = ListUtil.createList((Object[])new JavaField[]{((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build(), ((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()});
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).fields(fields).build();
        Assertions.assertEquals((Object)fields, (Object)this.clazz.getFields());
    }

    @Test
    public void testBuilderSetField() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).build();
        List fields = this.clazz.getFields();
        Assertions.assertEquals((int)1, (int)fields.size());
        JavaField field = (JavaField)fields.get(0);
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)field.getVisibility());
        Assertions.assertEquals((Object)"int", (Object)field.getType());
        Assertions.assertEquals((Object)"test", (Object)field.getName());
    }

    @Test
    public void testBuilderSetMethods() {
        List methods = ListUtil.createList((Object[])new JavaMethod[]{((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").build(), ((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").build()});
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).methods(methods).build();
        Assertions.assertEquals((Object)methods, (Object)this.clazz.getMethods());
    }

    @Test
    public void testBuilderSetMethod() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("int").name("someMethod").line("return 42;").build()).build();
        List methods = this.clazz.getMethods();
        Assertions.assertEquals((int)1, (int)methods.size());
        JavaMethod method = (JavaMethod)methods.get(0);
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)method.getVisibility());
        Assertions.assertEquals((Object)"int", (Object)method.getReturnType());
        Assertions.assertEquals((Object)"someMethod", (Object)method.getName());
        Assertions.assertTrue((boolean)method.getParameters().isEmpty());
        List lines = method.getLines();
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertEquals((Object)"return 42;", lines.get(0));
    }

    @Test
    public void testBuilderNullPackageName() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify packageName when not making an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderNullClassName() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderInnerClassNotInnerClass() {
        try {
            JavaClass inner = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).build();
            this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className("BClassName").innerClass(inner).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Inner class 'AClassName' is not an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderOuterClassCantBeStatic() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).isStatic().packageName(this.packageName).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Only inner classes can be static!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAllOuterClassErrors() {
        try {
            JavaClass inner = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).build();
            this.clazz = ((JavaClassBuilder)this.builder.get()).isStatic().innerClass(inner).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!\nInner class 'AClassName' is not an inner class!\nMust specify packageName when not making an inner class!\nOnly inner classes can be static!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderNullClassNameInnerClass() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderInnerClassNotInnerClassInInnerClass() {
        try {
            JavaClass inner = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).build();
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").innerClass(inner).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Inner class 'AClassName' is not an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderSetPackageNameInnerClass() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().packageName(this.packageName).className(this.className).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Not allowed to have packageName for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderSetImportInnerClass() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).singleImport("an.import").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Not allowed to have imports for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderSetStaticImportInnerClass() {
        try {
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).staticImport("an.other.import").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Not allowed to have static imports for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testBuilderAllInnerClassBuilderErrors() {
        try {
            JavaClass inner = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).build();
            this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().packageName(this.packageName).innerClass(inner).singleImport("an.import").staticImport("an.other.import").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify className!\nInner class 'AClassName' is not an inner class!\nNot allowed to have packageName for an inner class!\nNot allowed to have imports for an inner class!\nNot allowed to have static imports for an inner class!", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithSuperClassName() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).superClassName("AnotherClassName").build();
        String javaString = "package some.package;\n\npublic class AClassName extends AnotherClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithJavadoc() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).build();
        String javaString = "package some.package;\n\n/**\n */\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).annotations(annotations).build();
        String javaString = "package some.package;\n\n@Test\n@Derp\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithImports() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).imports(ListUtil.createList((Object[])new String[]{"com.example.*", null, "com.github.tadukoo.*"})).build();
        String javaString = "package some.package;\n\nimport com.example.*;\n\nimport com.github.tadukoo.*;\n\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithStaticImports() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).staticImports(ListUtil.createList((Object[])new String[]{"com.example.Test", null, "com.github.tadukoo.test.*"})).build();
        String javaString = "package some.package;\n\nimport static com.example.Test;\n\nimport static com.github.tadukoo.test.*;\n\npublic class AClassName{\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithInnerClasses() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).build();
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n\tpublic class BClassName{\n\t\t\n\t}\n\t\n\tpublic class CClassName{\n\t\t\n\t}\n\t\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithFields() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).build();
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n\tprivate int test;\n\tprivate String derp;\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithFieldsWithJavadocsOnFields() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).javadoc(((JavadocBuilder)this.javadocBuilder.get()).condensed().content("something").build()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).build();
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n\t/** something */\n\tprivate int test;\n\tprivate String derp;\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithMethods() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).className(this.className).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        String javaString = "package some.package;\n\npublic class AClassName{\n\t\n\tpublic AClassName(){\n\t}\n\t\n\tpublic String getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringWithEverything() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).imports(ListUtil.createList((Object[])new String[]{"com.example.*", "", "com.github.tadukoo.*"})).staticImports(ListUtil.createList((Object[])new String[]{"com.example.Test", "", "com.github.tadukoo.test.*"})).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).className(this.className).superClassName("AnotherClassName").innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        String javaString = "package some.package;\n\nimport com.example.*;\n\nimport com.github.tadukoo.*;\n\nimport static com.example.Test;\n\nimport static com.github.tadukoo.test.*;\n\n/**\n */\n@Test\n@Derp\npublic class AClassName extends AnotherClassName{\n\t\n\tpublic class BClassName{\n\t\t\n\t}\n\t\n\tpublic class CClassName{\n\t\t\n\t}\n\t\n\tprivate int test;\n\tprivate String derp;\n\t\n\tpublic AClassName(){\n\t}\n\t\n\tpublic String getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testToStringInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().className(this.className).build();
        Assertions.assertEquals((Object)"public class AClassName{\n\t\n}\n", (Object)this.clazz.toString());
    }

    @Test
    public void testToStringStaticInnerClass() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().isStatic().className(this.className).build();
        Assertions.assertEquals((Object)"public static class AClassName{\n\t\n}\n", (Object)this.clazz.toString());
    }

    @Test
    public void testToStringInnerClassWithEverything() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).innerClass().javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).isStatic().className(this.className).superClassName("AnotherClassName").innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        String javaString = "/**\n */\n@Test\n@Derp\npublic static class AClassName extends AnotherClassName{\n\t\n\tpublic class BClassName{\n\t\t\n\t}\n\t\n\tpublic class CClassName{\n\t\t\n\t}\n\t\n\tprivate int test;\n\tprivate String derp;\n\t\n\tpublic AClassName(){\n\t}\n\t\n\tpublic String getSomething(int test){\n\t\treturn doSomething();\n\t}\n}\n";
        Assertions.assertEquals((Object)javaString, (Object)this.clazz.toString());
    }

    @Test
    public void testEquals() {
        this.clazz = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).imports(ListUtil.createList((Object[])new String[]{"com.example.*", "", "com.github.tadukoo.*"})).staticImports(ListUtil.createList((Object[])new String[]{"com.example.Test", "", "com.github.tadukoo.test.*"})).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).className(this.className).superClassName("AnotherClassName").innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        JavaClass otherClass = ((JavaClassBuilder)this.builder.get()).packageName(this.packageName).imports(ListUtil.createList((Object[])new String[]{"com.example.*", "", "com.github.tadukoo.*"})).staticImports(ListUtil.createList((Object[])new String[]{"com.example.Test", "", "com.github.tadukoo.test.*"})).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).className(this.className).superClassName("AnotherClassName").innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("BClassName").build()).innerClass(((JavaClassBuilder)this.builder.get()).innerClass().className("CClassName").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("int").name("test").build()).field(((JavaFieldBuilder)this.javaFieldBuilder.get()).type("String").name("derp").build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType(this.className).build()).method(((JavaMethodBuilder)this.javaMethodBuilder.get()).returnType("String").name("getSomething").parameter("int", "test").line("return doSomething();").build()).build();
        Assertions.assertEquals(this.clazz, (Object)otherClass);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaClass otherClass = ((JavaClassBuilder)this.builder.get()).packageName("some.package.different").className(this.className).build();
        Assertions.assertNotEquals(this.clazz, (Object)otherClass);
    }

    @Test
    public void testEqualsNotSameType() {
        Assertions.assertNotEquals(this.clazz, (Object)"testing");
    }
}

