/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaAnnotationBuilder;
import com.github.tadukoo.java.JavaField;
import com.github.tadukoo.java.JavaFieldBuilder;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.JavadocBuilder;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaFieldTest<FieldType extends JavaField> {
    private final ThrowingSupplier<JavaFieldBuilder<FieldType>, NoException> builder;
    private final ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder;
    private final ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder;
    protected FieldType field;
    protected String type;
    protected String name;

    protected DefaultJavaFieldTest(ThrowingSupplier<JavaFieldBuilder<FieldType>, NoException> builder, ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder, ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder) {
        this.builder = builder;
        this.javadocBuilder = javadocBuilder;
        this.javaAnnotationBuilder = javaAnnotationBuilder;
    }

    @BeforeEach
    public void setup() {
        this.type = "int";
        this.name = "test";
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).build();
    }

    @Test
    public void testDefaultSectionComment() {
        Assertions.assertNull((Object)this.field.getSectionComment());
    }

    @Test
    public void testDefaultJavadoc() {
        Assertions.assertNull((Object)this.field.getJavadoc());
    }

    @Test
    public void testDefaultAnnotations() {
        Assertions.assertTrue((boolean)this.field.getAnnotations().isEmpty());
    }

    @Test
    public void testDefaultVisibility() {
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)this.field.getVisibility());
    }

    @Test
    public void testDefaultIsStatic() {
        Assertions.assertFalse((boolean)this.field.isStatic());
    }

    @Test
    public void testDefaultIsFinal() {
        Assertions.assertFalse((boolean)this.field.isFinal());
    }

    @Test
    public void testDefaultValue() {
        Assertions.assertNull((Object)this.field.getValue());
    }

    @Test
    public void testSetType() {
        Assertions.assertEquals((Object)"int", (Object)this.field.getType());
    }

    @Test
    public void testSetName() {
        Assertions.assertEquals((Object)"test", (Object)this.field.getName());
    }

    @Test
    public void testBuilderSetSectionComment() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).sectionComment("Test comment").build();
        Assertions.assertEquals((Object)"Test comment", (Object)this.field.getSectionComment());
    }

    @Test
    public void testBuilderSetJavadoc() {
        Javadoc doc = ((JavadocBuilder)this.javadocBuilder.get()).build();
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).javadoc(doc).build();
        Assertions.assertEquals((Object)doc, (Object)this.field.getJavadoc());
    }

    @Test
    public void testBuilderSetAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.field = ((JavaFieldBuilder)this.builder.get()).annotations(annotations).type(this.type).name(this.name).build();
        Assertions.assertEquals((Object)annotations, (Object)this.field.getAnnotations());
    }

    @Test
    public void testBuilderSetAnnotation() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.field = ((JavaFieldBuilder)this.builder.get()).annotation(test).type(this.type).name("Test").build();
        List annotations = this.field.getAnnotations();
        Assertions.assertEquals((int)1, (int)annotations.size());
        Assertions.assertEquals((Object)test, annotations.get(0));
    }

    @Test
    public void testBuilderSetVisibility() {
        this.field = ((JavaFieldBuilder)this.builder.get()).visibility(Visibility.PUBLIC).type(this.type).name(this.name).build();
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)this.field.getVisibility());
    }

    @Test
    public void testBuilderSetIsStatic() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).isStatic(false).build();
        Assertions.assertFalse((boolean)this.field.isStatic());
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).isStatic(true).build();
        Assertions.assertTrue((boolean)this.field.isStatic());
    }

    @Test
    public void testBuilderIsStatic() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).isStatic().build();
        Assertions.assertTrue((boolean)this.field.isStatic());
    }

    @Test
    public void testBuilderSetIsFinal() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).isFinal(false).build();
        Assertions.assertFalse((boolean)this.field.isFinal());
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).isFinal(true).build();
        Assertions.assertTrue((boolean)this.field.isFinal());
    }

    @Test
    public void testBuilderIsFinal() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).isFinal().build();
        Assertions.assertTrue((boolean)this.field.isFinal());
    }

    @Test
    public void testBuilderSetValue() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).value("42").build();
        Assertions.assertEquals((Object)"42", (Object)this.field.getValue());
    }

    @Test
    public void testNullType() {
        try {
            this.field = ((JavaFieldBuilder)this.builder.get()).name(this.name).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify type!", (Object)e.getMessage());
        }
    }

    @Test
    public void testNullName() {
        try {
            this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify name!", (Object)e.getMessage());
        }
    }

    @Test
    public void testNullTypeAndName() {
        try {
            this.field = ((JavaFieldBuilder)this.builder.get()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify type!\nMust specify name!", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"private int test", (Object)this.field.toString());
    }

    @Test
    public void testToStringWithSectionComment() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).sectionComment("Test comment").build();
        String javaString = "/*\n * Test comment\n */\n\nprivate int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithJavadoc() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).build();
        String javaString = "/**\n */\nprivate int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithSingleAnnotation() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).annotation(test).build();
        String javaString = "@Test\nprivate int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).annotation(test).annotation(derp).build();
        String javaString = "@Test\n@Derp\nprivate int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithIsStatic() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).isStatic().build();
        String javaString = "private static int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithIsFinal() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).isFinal().build();
        String javaString = "private final int test";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testToStringWithValue() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).value("42").build();
        Assertions.assertEquals((Object)"private int test = 42", (Object)this.field.toString());
    }

    @Test
    public void testToStringWithEverything() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).isStatic().isFinal().value("42").build();
        String javaString = "/*\n * Test comment\n */\n\n/**\n */\n@Test\n@Derp\nprivate static final int test = 42";
        Assertions.assertEquals((Object)javaString, (Object)this.field.toString());
    }

    @Test
    public void testEquals() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).isStatic().isFinal().value("42").build();
        JavaField otherField = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).isStatic().isFinal().value("42").build();
        Assertions.assertEquals(this.field, (Object)otherField);
    }

    @Test
    public void testEqualsNotEqual() {
        this.field = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).isStatic().isFinal().value("42").build();
        JavaField otherField = ((JavaFieldBuilder)this.builder.get()).type(this.type).name(this.name).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build()).annotation(((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build()).isStatic().isFinal().value("41").build();
        Assertions.assertNotEquals(this.field, (Object)otherField);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals(this.field, (Object)"testing");
    }
}

