/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaAnnotation;
import com.github.tadukoo.java.JavaAnnotationBuilder;
import com.github.tadukoo.java.JavaMethod;
import com.github.tadukoo.java.JavaMethodBuilder;
import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.JavadocBuilder;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import com.github.tadukoo.util.tuple.Pair;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavaMethodTest<MethodType extends JavaMethod> {
    private final ThrowingSupplier<JavaMethodBuilder<MethodType>, NoException> builder;
    private final ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder;
    private final ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder;
    protected MethodType method;
    protected String returnType;

    protected DefaultJavaMethodTest(ThrowingSupplier<JavaMethodBuilder<MethodType>, NoException> builder, ThrowingSupplier<JavadocBuilder<?>, NoException> javadocBuilder, ThrowingSupplier<JavaAnnotationBuilder<?>, NoException> javaAnnotationBuilder) {
        this.builder = builder;
        this.javadocBuilder = javadocBuilder;
        this.javaAnnotationBuilder = javaAnnotationBuilder;
    }

    @BeforeEach
    public void setup() {
        this.returnType = "int";
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).build();
    }

    @Test
    public void testDefaultSectionComment() {
        Assertions.assertNull((Object)this.method.getSectionComment());
    }

    @Test
    public void testDefaultJavadoc() {
        Assertions.assertNull((Object)this.method.getJavadoc());
    }

    @Test
    public void testDefaultAnnotations() {
        Assertions.assertTrue((boolean)this.method.getAnnotations().isEmpty());
    }

    @Test
    public void testDefaultVisibility() {
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)this.method.getVisibility());
    }

    @Test
    public void testDefaultIsStatic() {
        Assertions.assertFalse((boolean)this.method.isStatic());
    }

    @Test
    public void testDefaultName() {
        Assertions.assertNull((Object)this.method.getName());
    }

    @Test
    public void testDefaultParameters() {
        Assertions.assertTrue((boolean)this.method.getParameters().isEmpty());
    }

    @Test
    public void testDefaultThrowTypes() {
        Assertions.assertTrue((boolean)this.method.getThrowTypes().isEmpty());
    }

    @Test
    public void testDefaultLines() {
        Assertions.assertTrue((boolean)this.method.getLines().isEmpty());
    }

    @Test
    public void testBuilderSetSectionComment() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).sectionComment("Test section").build();
        Assertions.assertEquals((Object)"Test section", (Object)this.method.getSectionComment());
    }

    @Test
    public void testBuilderSetJavadoc() {
        Javadoc javadoc = ((JavadocBuilder)this.javadocBuilder.get()).build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).javadoc(javadoc).build();
        Assertions.assertEquals((Object)javadoc, (Object)this.method.getJavadoc());
    }

    @Test
    public void testBuilderSetAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        List annotations = ListUtil.createList((Object[])new JavaAnnotation[]{test, derp});
        this.method = ((JavaMethodBuilder)this.builder.get()).annotations(annotations).returnType("String").build();
        Assertions.assertEquals((Object)annotations, (Object)this.method.getAnnotations());
    }

    @Test
    public void testBuilderSetAnnotation() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).annotation(test).returnType("String").build();
        List annotations = this.method.getAnnotations();
        Assertions.assertEquals((int)1, (int)annotations.size());
        Assertions.assertEquals((Object)test, annotations.get(0));
    }

    @Test
    public void testBuilderSetVisibility() {
        this.method = ((JavaMethodBuilder)this.builder.get()).visibility(Visibility.PRIVATE).returnType("String").build();
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)this.method.getVisibility());
    }

    @Test
    public void testBuilderIsStatic() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isStatic().returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isStatic());
    }

    @Test
    public void testBuilderSetIsStatic() {
        this.method = ((JavaMethodBuilder)this.builder.get()).isStatic(false).returnType("String").build();
        Assertions.assertFalse((boolean)this.method.isStatic());
        this.method = ((JavaMethodBuilder)this.builder.get()).isStatic(true).returnType("String").build();
        Assertions.assertTrue((boolean)this.method.isStatic());
    }

    @Test
    public void testBuilderSetReturnType() {
        Assertions.assertEquals((Object)"int", (Object)this.method.getReturnType());
    }

    @Test
    public void testBuilderSetName() {
        this.method = ((JavaMethodBuilder)this.builder.get()).name("someName").returnType(this.returnType).build();
        Assertions.assertEquals((Object)"someName", (Object)this.method.getName());
    }

    @Test
    public void testBuilderSetParameters() {
        List parameters = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"int", (Object)"someInt"), Pair.of((Object)"String", (Object)"someText")});
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameters(parameters).build();
        Assertions.assertEquals((Object)parameters, (Object)this.method.getParameters());
    }

    @Test
    public void testBuilderSetParameterPair() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter(Pair.of((Object)"String", (Object)"someText")).build();
        List parameters = this.method.getParameters();
        Assertions.assertEquals((int)1, (int)parameters.size());
        Pair parameter = (Pair)parameters.get(0);
        Assertions.assertEquals((Object)"String", (Object)parameter.getLeft());
        Assertions.assertEquals((Object)"someText", (Object)parameter.getRight());
    }

    @Test
    public void testBuilderSetParameter() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "someText").build();
        List parameters = this.method.getParameters();
        Assertions.assertEquals((int)1, (int)parameters.size());
        Pair parameter = (Pair)parameters.get(0);
        Assertions.assertEquals((Object)"String", (Object)parameter.getLeft());
        Assertions.assertEquals((Object)"someText", (Object)parameter.getRight());
    }

    @Test
    public void testBuilderSetThrowTypes() {
        List throwTypes = ListUtil.createList((Object[])new String[]{"Throwable", "Exception"});
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwTypes(throwTypes).build();
        Assertions.assertEquals((Object)throwTypes, (Object)this.method.getThrowTypes());
    }

    @Test
    public void testBuilderSetThrowType() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwType("Throwable").build();
        List throwTypes = this.method.getThrowTypes();
        Assertions.assertEquals((int)1, (int)throwTypes.size());
        Assertions.assertEquals((Object)"Throwable", throwTypes.get(0));
    }

    @Test
    public void testBuilderSetLines() {
        List lines = ListUtil.createList((Object[])new String[]{"doSomething();", "return 42;"});
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).lines(lines).build();
        Assertions.assertEquals((Object)lines, (Object)this.method.getLines());
    }

    @Test
    public void testBuilderSetLine() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).line("return 42;").build();
        List lines = this.method.getLines();
        Assertions.assertEquals((int)1, (int)lines.size());
        Assertions.assertEquals((Object)"return 42;", lines.get(0));
    }

    @Test
    public void testBuilderNullReturnType() {
        try {
            this.method = ((JavaMethodBuilder)this.builder.get()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Must specify returnType!", (Object)e.getMessage());
        }
    }

    @Test
    public void testToString() {
        String javaString = "public int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSectionComment() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).sectionComment("Test comment").build();
        String javaString = "/*\n * Test comment\n */\n\npublic int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithJavadoc() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).build();
        String javaString = "/**\n */\npublic int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSingleAnnotation() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).annotation(test).build();
        String javaString = "@Test\npublic int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithAnnotations() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).annotation(test).annotation(derp).build();
        String javaString = "@Test\n@Derp\npublic int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithIsStatic() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).isStatic().build();
        String javaString = "public static int(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithName() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).name("someMethod").build();
        String javaString = "public int someMethod(){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSingleParameter() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "text").build();
        String javaString = "public int(String text){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithParameters() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).parameter("String", "text").parameter("int", "something").build();
        String javaString = "public int(String text, int something){\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithSingleThrowType() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwType("Throwable").build();
        String javaString = "public int() throws Throwable{\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithThrowTypes() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).throwType("Throwable").throwType("Exception").build();
        String javaString = "public int() throws Throwable, Exception{\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithLines() {
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).line("doSomething();").line("return 42;").build();
        String javaString = "public int(){\n\tdoSomething();\n\treturn 42;\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testToStringWithEverything() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        String javaString = "/*\n * Test comment\n */\n\n/**\n */\n@Test\n@Derp\npublic static int someMethod(String text, int something) throws Throwable, Exception{\n\tdoSomething();\n\treturn 42;\n}";
        Assertions.assertEquals((Object)javaString, (Object)this.method.toString());
    }

    @Test
    public void testEquals() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        JavaMethod otherMethod = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        Assertions.assertEquals(this.method, (Object)otherMethod);
    }

    @Test
    public void testEqualsNotEqual() {
        JavaAnnotation test = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Test").build();
        JavaAnnotation derp = ((JavaAnnotationBuilder)this.javaAnnotationBuilder.get()).name("Derp").build();
        this.method = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build();
        JavaMethod otherMethod = ((JavaMethodBuilder)this.builder.get()).returnType(this.returnType).sectionComment("Test comment").javadoc(((JavadocBuilder)this.javadocBuilder.get()).build()).annotation(test).annotation(derp).name("someMethod").isStatic().parameter("String", "text").parameter("int", "something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 41;").build();
        Assertions.assertNotEquals(this.method, (Object)otherMethod);
    }

    @Test
    public void testEqualsDifferentTypes() {
        Assertions.assertNotEquals(this.method, (Object)"testing");
    }
}

