/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.Javadoc;
import com.github.tadukoo.java.JavadocBuilder;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.NoException;
import com.github.tadukoo.util.functional.supplier.ThrowingSupplier;
import com.github.tadukoo.util.tuple.Pair;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class DefaultJavadocTest<JavadocType extends Javadoc> {
    protected ThrowingSupplier<JavadocBuilder<JavadocType>, NoException> builder;
    protected JavadocType doc;

    protected DefaultJavadocTest(ThrowingSupplier<JavadocBuilder<JavadocType>, NoException> builder) {
        this.builder = builder;
    }

    @BeforeEach
    public void setup() {
        this.doc = ((JavadocBuilder)this.builder.get()).build();
    }

    @Test
    public void testDefaultCondensed() {
        Assertions.assertFalse((boolean)this.doc.isCondensed());
    }

    @Test
    public void testDefaultContent() {
        List content = this.doc.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertEquals((int)0, (int)content.size());
    }

    @Test
    public void testDefaultAuthor() {
        Assertions.assertNull((Object)this.doc.getAuthor());
    }

    @Test
    public void testDefaultVersion() {
        Assertions.assertNull((Object)this.doc.getVersion());
    }

    @Test
    public void testDefaultSince() {
        Assertions.assertNull((Object)this.doc.getSince());
    }

    @Test
    public void testDefaultParams() {
        List params = this.doc.getParams();
        Assertions.assertNotNull((Object)params);
        Assertions.assertEquals((int)0, (int)params.size());
    }

    @Test
    public void testDefaultReturnVal() {
        Assertions.assertNull((Object)this.doc.getReturnVal());
    }

    @Test
    public void testBuilderSetCondensedValue() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed(true).build();
        Assertions.assertTrue((boolean)this.doc.isCondensed());
    }

    @Test
    public void testBuilderSetCondensed() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().build();
        Assertions.assertTrue((boolean)this.doc.isCondensed());
    }

    @Test
    public void testBuilderSetContent() {
        List content = ListUtil.createList((Object[])new String[]{"test", "derp"});
        this.doc = ((JavadocBuilder)this.builder.get()).content(content).build();
        Assertions.assertEquals((Object)content, (Object)this.doc.getContent());
    }

    @Test
    public void testBuilderSetContentLine() {
        String content = "test";
        this.doc = ((JavadocBuilder)this.builder.get()).content(content).build();
        List actContent = this.doc.getContent();
        Assertions.assertEquals((int)1, (int)actContent.size());
        Assertions.assertEquals((Object)content, actContent.get(0));
    }

    @Test
    public void testBuilderSetAuthor() {
        this.doc = ((JavadocBuilder)this.builder.get()).author("Logan Ferree (Tadukoo)").build();
        Assertions.assertEquals((Object)"Logan Ferree (Tadukoo)", (Object)this.doc.getAuthor());
    }

    @Test
    public void testBuilderSetVersion() {
        this.doc = ((JavadocBuilder)this.builder.get()).version("Alpha v.0.1").build();
        Assertions.assertEquals((Object)"Alpha v.0.1", (Object)this.doc.getVersion());
    }

    @Test
    public void testBuilderSetSince() {
        this.doc = ((JavadocBuilder)this.builder.get()).since("Alpha v.0.0.1").build();
        Assertions.assertEquals((Object)"Alpha v.0.0.1", (Object)this.doc.getSince());
    }

    @Test
    public void testBuilderSetParams() {
        List params = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes"), Pair.of((Object)"derp", (Object)"no")});
        this.doc = ((JavadocBuilder)this.builder.get()).params(params).build();
        Assertions.assertEquals((Object)params, (Object)this.doc.getParams());
    }

    @Test
    public void testBuilderSetParamPair() {
        Pair param = Pair.of((Object)"test", (Object)"yes");
        this.doc = ((JavadocBuilder)this.builder.get()).param(param).build();
        List params = this.doc.getParams();
        Assertions.assertEquals((int)1, (int)params.size());
        Assertions.assertEquals((Object)param, params.get(0));
    }

    @Test
    public void testBuilderSetParamPieces() {
        this.doc = ((JavadocBuilder)this.builder.get()).param("test", "yes").build();
        List params = this.doc.getParams();
        Assertions.assertEquals((int)1, (int)params.size());
        Pair param = (Pair)params.get(0);
        Assertions.assertEquals((Object)"test", (Object)param.getLeft());
        Assertions.assertEquals((Object)"yes", (Object)param.getRight());
    }

    @Test
    public void testBuilderSetReturnVal() {
        this.doc = ((JavadocBuilder)this.builder.get()).returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"this, to continue building", (Object)this.doc.getReturnVal());
    }

    @Test
    public void testBuilderSetAll() {
        List content = ListUtil.createList((Object[])new String[]{"test", "derp"});
        List params = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes"), Pair.of((Object)"derp", (Object)"no")});
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().content(content).author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").params(params).returnVal("this, to continue building").build();
        Assertions.assertTrue((boolean)this.doc.isCondensed());
        Assertions.assertEquals((Object)content, (Object)this.doc.getContent());
        Assertions.assertEquals((Object)"Logan Ferree (Tadukoo)", (Object)this.doc.getAuthor());
        Assertions.assertEquals((Object)"Alpha v.0.1", (Object)this.doc.getVersion());
        Assertions.assertEquals((Object)"Alpha v.0.0.1", (Object)this.doc.getSince());
        Assertions.assertEquals((Object)params, (Object)this.doc.getParams());
        Assertions.assertEquals((Object)"this, to continue building", (Object)this.doc.getReturnVal());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"/**\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithContent() {
        this.doc = ((JavadocBuilder)this.builder.get()).content("test").content("derp").build();
        Assertions.assertEquals((Object)"/**\n * test\n * derp\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithAuthor() {
        this.doc = ((JavadocBuilder)this.builder.get()).author("Logan Ferree (Tadukoo)").build();
        Assertions.assertEquals((Object)"/**\n * @author Logan Ferree (Tadukoo)\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithVersion() {
        this.doc = ((JavadocBuilder)this.builder.get()).version("Alpha v.0.1").build();
        Assertions.assertEquals((Object)"/**\n * @version Alpha v.0.1\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithSince() {
        this.doc = ((JavadocBuilder)this.builder.get()).since("Alpha v.0.0.1").build();
        Assertions.assertEquals((Object)"/**\n * @since Alpha v.0.0.1\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithSingleParam() {
        this.doc = ((JavadocBuilder)this.builder.get()).param("test", "yes").build();
        Assertions.assertEquals((Object)"/**\n * @param test yes\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithMultipleParams() {
        this.doc = ((JavadocBuilder)this.builder.get()).param("test", "yes").param("derp", "no").build();
        Assertions.assertEquals((Object)"/**\n * @param test yes\n * @param derp no\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithReturnVal() {
        this.doc = ((JavadocBuilder)this.builder.get()).returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"/**\n * @return this, to continue building\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithEverything() {
        this.doc = ((JavadocBuilder)this.builder.get()).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"/**\n * test\n * derp\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n * @since Alpha v.0.0.1\n * \n * @param test yes\n * @param derp no\n * @return this, to continue building\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringCondensed() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().build();
        Assertions.assertEquals((Object)"/** */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithContentCondensed() {
        List content = ListUtil.createList((Object[])new String[]{"test", "derp"});
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().content(content).build();
        Assertions.assertEquals((Object)"/** test\n * derp */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithAuthorCondensed() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().author("Logan Ferree (Tadukoo)").build();
        Assertions.assertEquals((Object)"/** @author Logan Ferree (Tadukoo) */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithVersionCondensed() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().version("Alpha v.0.1").build();
        Assertions.assertEquals((Object)"/** @version Alpha v.0.1 */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithSinceCondensed() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().since("Alpha v.0.0.1").build();
        Assertions.assertEquals((Object)"/** @since Alpha v.0.0.1 */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithSingleParamCondensed() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().param("test", "yes").build();
        Assertions.assertEquals((Object)"/** @param test yes */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithMultipleParamsCondensed() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().param("test", "yes").param("derp", "no").build();
        Assertions.assertEquals((Object)"/** @param test yes\n * @param derp no */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithReturnValCondensed() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"/** @return this, to continue building */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringWithEverythingCondensed() {
        this.doc = ((JavadocBuilder)this.builder.get()).condensed().content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)"/** test\n * derp\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n * @since Alpha v.0.0.1\n * \n * @param test yes\n * @param derp no\n * @return this, to continue building */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringContentAndInfoAnnotations() {
        this.doc = ((JavadocBuilder)this.builder.get()).content("test").author("Me").build();
        Assertions.assertEquals((Object)"/**\n * test\n * \n * @author Me\n */", (Object)this.doc.toString());
    }

    @Test
    public void testToStringContentAndCodeAnnotations() {
        this.doc = ((JavadocBuilder)this.builder.get()).content("test").returnVal("this").build();
        Assertions.assertEquals((Object)"/**\n * test\n * \n * @return this\n */", (Object)this.doc.toString());
    }

    @Test
    public void testEquals() {
        this.doc = ((JavadocBuilder)this.builder.get()).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Javadoc otherDoc = ((JavadocBuilder)this.builder.get()).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Assertions.assertEquals((Object)otherDoc, this.doc);
    }

    @Test
    public void testEqualsNotEqual() {
        this.doc = ((JavadocBuilder)this.builder.get()).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Javadoc otherDoc = ((JavadocBuilder)this.builder.get()).content("tes").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build();
        Assertions.assertNotEquals((Object)otherDoc, this.doc);
    }

    @Test
    public void testEqualsDifferentType() {
        Assertions.assertNotEquals(this.doc, (Object)"test");
    }
}

